/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thedarkcolour.core.block.InteractionBlock;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;
import thedarkcolour.futuremc.tile.TileComposter;

public class BlockComposter
extends InteractionBlock {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)8);
    protected static final AxisAlignedBB AABB_LEGS = BlockComposter.makeAABB(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public BlockComposter() {
        super("Composter", Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78026_f : FutureMC.TAB));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LEVEL});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
        if ((Integer)state.func_177229_b((IProperty)LEVEL) > 0) {
            double level = (double)((Integer)state.func_177229_b((IProperty)LEVEL)).intValue() == 8.0 ? 6.0 : (double)((Integer)state.func_177229_b((IProperty)LEVEL)).intValue() - 1.0;
            BlockComposter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BlockComposter.makeAABB(2.0, 2.0, 2.0, 14.0, 3.0 + 2.0 * level, 14.0));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.func_175625_s(pos) instanceof TileComposter) {
            TileComposter te = (TileComposter)worldIn.func_175625_s(pos);
            if (BlockComposter.canCompost(stack, state)) {
                this.spawnBonemealParticles(worldIn, pos);
                if (!worldIn.field_72995_K) {
                    te.addItem(stack, !playerIn.func_184812_l_());
                    return true;
                }
            }
            if (!worldIn.field_72995_K && (Integer)state.func_177229_b((IProperty)LEVEL) == 8) {
                te.extractBoneMeal();
            }
        }
        return true;
    }

    public void spawnBonemealParticles(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d0 = 0.53125;
        double d1 = 0.13125f;
        double d2 = 0.7375f;
        for (int i = 0; i < 10; ++i) {
            double d3 = random.nextGaussian() * 0.02;
            double d4 = random.nextGaussian() * 0.02;
            double d5 = random.nextGaussian() * 0.02;
            worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + d1 + d2 * (double)random.nextFloat(), (double)pos.func_177956_o() + d0 + (double)random.nextFloat() * (1.0 - d0), (double)pos.func_177952_p() + d1 + d2 * (double)random.nextFloat(), d3, d4, d5, new int[0]);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)LEVEL) == 7) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(8)));
            worldIn.func_184133_a(null, pos, Sounds.COMPOSTER_READY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            ((TileComposter)worldIn.func_175625_s(pos)).getBuffer().setStackInSlot(0, new ItemStack(Items.field_151100_aR, 1, 15));
        }
    }

    public static boolean canCompost(ItemStack stack, IBlockState state) {
        return ItemsForComposter.getChance(stack) != -1 && !BlockComposter.isFull(state);
    }

    public static boolean isFull(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL) >= 7;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileComposter();
    }

    public static final class ItemsForComposter {
        private static HashMap<ItemStack, Integer> VALID_ITEMS = new HashMap();

        private static void add(IForgeRegistryEntry<?> registryObject, Rarity rarity) {
            if (registryObject instanceof Block) {
                ItemsForComposter.add(new ItemStack((Block)registryObject), rarity);
            } else {
                ItemsForComposter.add(new ItemStack((Item)registryObject), rarity);
            }
        }

        public static void add(ItemStack stack, Rarity rarity) {
            ItemsForComposter.add(stack, rarity.getChance());
        }

        public static void add(ItemStack stack, int rarity) {
            VALID_ITEMS.put(stack, rarity);
        }

        public static int getChance(ItemStack stack) {
            if (stack.func_190926_b()) {
                return -1;
            }
            Optional<ItemStack> item = VALID_ITEMS.keySet().stream().filter(itemStack -> itemStack.func_77969_a(stack)).findFirst();
            return item.isPresent() ? VALID_ITEMS.get(item.get()) : -1;
        }

        public static void remove(ItemStack stack) {
            VALID_ITEMS.remove(stack);
        }

        public static void clear() {
            VALID_ITEMS.clear();
        }

        static {
            if (FutureConfig.general.composter) {
                ItemsForComposter.add(Items.field_185163_cU, Rarity.COMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150329_H, 1, 1), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150362_t, 1, 0), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150362_t, 1, 1), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150362_t, 1, 2), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150362_t, 1, 3), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150361_u, 1, 0), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150361_u, 1, 1), Rarity.COMMON);
                ItemsForComposter.add(Items.field_151081_bc, Rarity.COMMON);
                ItemsForComposter.add(Items.field_151080_bb, Rarity.COMMON);
                ItemsForComposter.add(new ItemStack(Blocks.field_150345_g, 1, 0), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack(Blocks.field_150345_g, 1, 1), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack(Blocks.field_150345_g, 1, 2), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack(Blocks.field_150345_g, 1, 3), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack(Blocks.field_150345_g, 1, 4), Rarity.COMMON);
                ItemsForComposter.add(new ItemStack(Blocks.field_150345_g, 1, 5), Rarity.COMMON);
                ItemsForComposter.add(Init.SWEET_BERRY, Rarity.COMMON);
                ItemsForComposter.add(Items.field_151014_N, Rarity.COMMON);
                ItemsForComposter.add(Items.field_151127_ba, Rarity.UNCOMMON);
                ItemsForComposter.add(Items.field_151120_aE, Rarity.UNCOMMON);
                ItemsForComposter.add(Blocks.field_150434_aF, Rarity.UNCOMMON);
                ItemsForComposter.add(Blocks.field_150395_bd, Rarity.UNCOMMON);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150398_cm, 1, 2), Rarity.UNCOMMON);
                ItemsForComposter.add(Items.field_151034_e, Rarity.RARE);
                ItemsForComposter.add(Items.field_185164_cV, Rarity.RARE);
                ItemsForComposter.add(Items.field_151172_bF, Rarity.RARE);
                ItemsForComposter.add(new ItemStack(Items.field_151100_aR, 1, 3), Rarity.RARE);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150329_H, 1, 2), Rarity.RARE);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150398_cm, 1, 3), Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150328_O, Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150327_N, Rarity.RARE);
                ItemsForComposter.add(Init.LILY_OF_VALLEY, Rarity.RARE);
                ItemsForComposter.add(Init.CORNFLOWER, Rarity.RARE);
                ItemsForComposter.add(Init.WITHER_ROSE, Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150398_cm, Rarity.RARE);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150398_cm, 1, 1), Rarity.RARE);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150398_cm, 1, 4), Rarity.RARE);
                ItemsForComposter.add(new ItemStack((Block)Blocks.field_150398_cm, 1, 5), Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150392_bi, Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150440_ba, Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150338_P, Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150337_Q, Rarity.RARE);
                ItemsForComposter.add(Items.field_151174_bG, Rarity.RARE);
                ItemsForComposter.add(Blocks.field_150423_aK, Rarity.RARE);
                ItemsForComposter.add(Items.field_151015_O, Rarity.RARE);
                ItemsForComposter.add(Items.field_151168_bH, Rarity.EPIC);
                ItemsForComposter.add(Items.field_151025_P, Rarity.EPIC);
                ItemsForComposter.add(Items.field_151106_aX, Rarity.EPIC);
                ItemsForComposter.add(Blocks.field_150407_cf, Rarity.EPIC);
                ItemsForComposter.add(Items.field_151105_aU, Rarity.LEGENDARY);
                ItemsForComposter.add(Items.field_151158_bO, Rarity.LEGENDARY);
            }
        }

        static enum Rarity {
            COMMON(30),
            UNCOMMON(50),
            RARE(65),
            EPIC(85),
            LEGENDARY(100);

            private final int chance;

            private Rarity(int chance) {
                this.chance = chance;
            }

            public int getChance() {
                return this.chance;
            }
        }
    }
}

