/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thedarkcolour.core.block.InteractionBlock;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.sound.Sounds;
import thedarkcolour.futuremc.tile.TileCampfire;

public class BlockCampfire
extends InteractionBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB BOUNDING_BOX = BlockCampfire.makeAABB(0.0, 0.0, 0.0, 16.0, 7.0, 16.0);
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockCampfire() {
        super("Campfire", Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHardness(2.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78031_c : FutureMC.TAB));
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCampfire();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 0xFFFFFFFB)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0) | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(!(block instanceof BlockLiquid | block instanceof IFluidBlock)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), Sounds.CAMPFIRE_CRACKLE, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.func_175688_a(EnumParticleTypes.LAVA, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f), new int[0]);
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175625_s(pos) instanceof TileCampfire) {
            ((TileCampfire)worldIn.func_175625_s(pos)).dropAllItems();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        this.harvesters.set(player);
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        this.func_176226_b(worldIn, pos, state, i);
        this.harvesters.set(null);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151044_h;
    }

    public int func_180651_a(IBlockState state) {
        return 1;
    }

    public int func_149745_a(Random random) {
        return 2;
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (block instanceof BlockFluidBase | block instanceof BlockLiquid) {
            this.setLit(worldIn, pos, false);
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (FutureConfig.general.campfireDMG && !entityIn.func_70045_F() && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
    }

    public void setLit(World worldIn, BlockPos pos, boolean lit) {
        if (!lit && worldIn.func_175625_s(pos) instanceof TileCampfire) {
            ((TileCampfire)worldIn.func_175625_s(pos)).dropAllItems();
        }
        worldIn.func_175656_a(pos, this.func_176194_O().func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.func_189540_a(state, worldIn, pos, worldIn.func_180495_p(pos).func_177230_c(), pos);
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }
}

