/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ForgeHooks;
import thedarkcolour.futuremc.block.BlockFlower;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;

public class BlockBerryBush
extends BlockFlower
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private static final AxisAlignedBB YOUNG = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.5, 0.7);
    private static final AxisAlignedBB MATURE = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.975, 0.9);
    public static final DamageSource BERRY_BUSH_DAMAGE = new DamageSource("berryBush");

    public BlockBerryBush() {
        super("BerryBush");
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        Item item = playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
        if (item != Items.field_151100_aR && item != Init.SWEET_BERRY) {
            if (worldIn.func_180495_p(pos).func_177230_c().func_176201_c(state) == 2) {
                worldIn.func_175656_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
                BlockBerryBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)Init.SWEET_BERRY));
            }
            if (worldIn.func_180495_p(pos).func_177230_c().func_176201_c(state) == 3) {
                worldIn.func_175656_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
                BlockBerryBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)Init.SWEET_BERRY, 3));
            }
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        boolean canGrow;
        boolean bl = canGrow = rand.nextInt(20) == 0;
        if (worldIn.func_175671_l(pos) >= 8 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)canGrow)) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (age < 3) {
                worldIn.func_180501_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase && !(entityIn instanceof EntityBee)) {
            entityIn.field_70143_R = 0.0f;
            entityIn.field_70159_w *= (double)0.8f;
            entityIn.field_70181_x *= 0.75;
            entityIn.field_70179_y *= (double)0.8f;
            if (!(worldIn.field_72995_K || (Integer)state.func_177229_b((IProperty)AGE) <= 0 || entityIn.field_70169_q == entityIn.field_70165_t && entityIn.field_70166_s == entityIn.field_70161_v)) {
                double double_1 = Math.abs(entityIn.field_70165_t - entityIn.field_70169_q);
                double double_2 = Math.abs(entityIn.field_70161_v - entityIn.field_70166_s);
                if (double_1 >= (double)0.003f || double_2 >= (double)0.003f) {
                    entityIn.func_70097_a(BERRY_BUSH_DAMAGE, 1.0f);
                }
            }
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_180495_p(pos).func_177230_c().func_176201_c(state) == 2) {
                worldIn.func_175656_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
                BlockBerryBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)Init.SWEET_BERRY));
            } else if (worldIn.func_180495_p(pos).func_177230_c().func_176201_c(state) == 3) {
                worldIn.func_175656_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
                BlockBerryBush.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)Init.SWEET_BERRY, 3));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 4) {
            return this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
        }
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)AGE) == 0 ? YOUNG : MATURE;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)Init.SWEET_BERRY);
    }

    @Override
    public boolean isBiomeValid(Biome biome) {
        return biome == Biomes.field_76768_g || biome == Biomes.field_76784_u || biome == Biomes.field_150584_S || biome == Biomes.field_150579_T || biome == Biomes.field_185432_ad || biome == Biomes.field_185433_ae || biome == Biomes.field_150578_U || biome == Biomes.field_150581_V || biome == Biomes.field_185431_ac;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 3;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        worldIn.func_175656_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
    }

    @Override
    public int getFlowerChance() {
        return FutureConfig.general.berryBushChance;
    }
}

