/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thedarkcolour.core.block.BlockRotatable;
import thedarkcolour.futuremc.sound.Sounds;
import thedarkcolour.futuremc.tile.TileBell;

public class BlockBell
extends BlockRotatable {
    public static final PropertyEnum<BellAttachment> ATTACHMENT = PropertyEnum.func_177709_a((String)"attachment", BellAttachment.class);

    public BlockBell() {
        super("bell", Material.field_151573_f, SoundType.field_185858_k);
        this.setHardness(5.0f);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBell();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.ring(worldIn, state, worldIn.func_175625_s(pos), hitY, facing, pos);
    }

    private boolean ring(World worldIn, IBlockState state, TileEntity te, float hitY, EnumFacing facing, BlockPos pos) {
        boolean flag = this.func_220129_a(state, facing, hitY - (float)pos.func_177956_o());
        if (!worldIn.field_72995_K && te instanceof TileBell && flag) {
            ((TileBell)te).func_213939_a(facing);
            this.playRingSound(worldIn, pos);
        }
        return true;
    }

    private boolean func_220129_a(IBlockState state, EnumFacing facing, float v) {
        if (facing.func_176740_k() != EnumFacing.Axis.Y && !(v > 0.8124f)) {
            EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
            BellAttachment bellattachment = (BellAttachment)((Object)state.func_177229_b(ATTACHMENT));
            switch (bellattachment) {
                case FLOOR: {
                    return direction.func_176740_k() == facing.func_176740_k();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return direction.func_176740_k() != facing.func_176740_k();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void playRingSound(World worldIn, BlockPos pos) {
        worldIn.func_184133_a(null, pos, Sounds.BELL_RING, SoundCategory.BLOCKS, 2.0f, 1.0f);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ATTACHMENT, FACING});
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing.Axis axis = facing.func_176740_k();
        if (axis == EnumFacing.Axis.Y) {
            IBlockState blockstate = this.func_176223_P().func_177226_a(ATTACHMENT, (Comparable)((Object)(facing == EnumFacing.DOWN ? BellAttachment.CEILING : BellAttachment.FLOOR))).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
            if (blockstate.func_177230_c().func_176196_c(worldIn, pos)) {
                return blockstate;
            }
        } else {
            boolean flag = axis == EnumFacing.Axis.X && this.isSideSolid(worldIn.func_180495_p(pos.func_177976_e()), (IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.EAST) && this.isSideSolid(worldIn.func_180495_p(pos.func_177974_f()), (IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.WEST) || axis == EnumFacing.Axis.Z && this.isSideSolid(worldIn.func_180495_p(pos.func_177978_c()), (IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.SOUTH) && this.isSideSolid(worldIn.func_180495_p(pos.func_177968_d()), (IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.NORTH);
            IBlockState blockstate1 = this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d()).func_177226_a(ATTACHMENT, (Comparable)((Object)(flag ? BellAttachment.DOUBLE_WALL : BellAttachment.SINGLE_WALL)));
            if (blockstate1.func_177230_c().func_176196_c(worldIn, pos)) {
                return blockstate1;
            }
            boolean flag1 = this.isSideSolid(worldIn.func_180495_p(pos.func_177977_b()), (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
            if ((blockstate1 = blockstate1.func_177226_a(ATTACHMENT, (Comparable)((Object)(flag1 ? BellAttachment.FLOOR : BellAttachment.CEILING)))).func_177230_c().func_176196_c(worldIn, pos)) {
                return blockstate1;
            }
        }
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ATTACHMENT, (Comparable)((Object)BellAttachment.values()[meta / 4])).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta % 4)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((BellAttachment)((Object)state.func_177229_b(ATTACHMENT))).ordinal() * 4 + ((BellAttachment)((Object)state.func_177229_b(ATTACHMENT))).ordinal();
    }

    public static enum BellAttachment implements IStringSerializable
    {
        FLOOR("floor"),
        CEILING("ceiling"),
        SINGLE_WALL("single_wall"),
        DOUBLE_WALL("double_wall");

        private final String name;

        private BellAttachment(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

