/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thedarkcolour.core.block.InteractionBlock;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.tile.TileBeeHive;

public class BlockBeeHive
extends InteractionBlock {
    public static final PropertyBool IS_FULL = PropertyBool.func_177716_a((String)"full");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockBeeHive(String regName) {
        super(regName, Material.field_151575_d, SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)IS_FULL, (Comparable)Boolean.valueOf(false)));
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78031_c : FutureMC.TAB));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177230_c() == Init.BEE_HIVE ? super.func_180660_a(state, rand, fortune) : Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public String getHarvestTool(IBlockState state) {
        return "axe";
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBeeHive();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, IS_FULL});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)IS_FULL, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 0xFFFFFFFB)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)IS_FULL) != false ? 4 : 0) | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof TileBeeHive) {
            return ((TileBeeHive)worldIn.func_175625_s(pos)).getHoneyLevel();
        }
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!worldIn.field_72995_K && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) == 0) {
            List nearbyPlayers;
            int players;
            List nearbyBees;
            if (worldIn.func_175625_s(pos) instanceof TileBeeHive) {
                ((TileBeeHive)worldIn.func_175625_s(pos)).angerBees(player, TileBeeHive.BeeState.DELIVERED);
                worldIn.func_175666_e(pos, (Block)this);
            }
            if (!(nearbyBees = worldIn.func_72872_a(EntityBee.class, new AxisAlignedBB(pos).func_72321_a(8.0, 6.0, 8.0))).isEmpty() && (players = (nearbyPlayers = worldIn.func_72872_a(EntityPlayer.class, new AxisAlignedBB(pos).func_72321_a(8.0, 6.0, 8.0))).size()) > 0) {
                for (EntityBee bee : nearbyBees) {
                    if (bee.func_70638_az() != null) continue;
                    bee.setBeeAttacker((Entity)nearbyPlayers.get(worldIn.field_73012_v.nextInt(players)));
                }
            }
        }
        return super.removedByPlayer(state, worldIn, pos, player, willHarvest);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    public BlockBeeHive setHardness(float hardness) {
        super.setHardness(hardness);
        return this;
    }
}

