/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import thedarkcolour.core.block.BlockBase;
import thedarkcolour.core.gui.Gui;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.tile.TileBarrel;

public class BlockBarrel
extends BlockBase
implements ITileEntityProvider {
    private static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");

    public BlockBarrel() {
        super("Barrel", Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHardness(2.0f);
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78031_c : FutureMC.TAB));
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileBarrel)) {
            return false;
        }
        Gui.BARREL.open(player, worldIn, pos);
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBarrel) {
            ItemStackHandler handler = ((TileBarrel)tile).getStorage();
            for (int i = 0; i < 27; ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                BlockBarrel.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta > 5 ? meta - 6 : meta))).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(meta > 5));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileBarrel();
    }
}

