/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thedarkcolour.core.block.BlockBase;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.init.FutureConfig;
import thedarkcolour.futuremc.init.Init;
import thedarkcolour.futuremc.sound.Sounds;

public class BlockBamboo
extends BlockBase
implements IGrowable {
    public static final PropertyBool THICK = PropertyBool.func_177716_a((String)"thick");
    public static final PropertyEnum<EnumLeaves> LEAVES = PropertyEnum.func_177709_a((String)"leaves", EnumLeaves.class);
    public static final PropertyBool MATURE = PropertyBool.func_177716_a((String)"mature");
    private static final AxisAlignedBB THICK_AABB = BlockBamboo.makeAABB(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    private static final AxisAlignedBB THIN_AABB = BlockBamboo.makeAABB(7.0, 0.0, 7.0, 9.0, 16.0, 9.0);

    public BlockBamboo() {
        super("Bamboo", Material.field_151585_k, Sounds.BAMBOO);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(false)).func_177226_a(LEAVES, (Comparable)((Object)EnumLeaves.NO_LEAVES)).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.setCreativeTab((CreativeTabs)(FutureConfig.general.useVanillaTabs ? CreativeTabs.field_78026_f : FutureMC.TAB));
        this.setHardness(1.0f);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Init.BAMBOO_STALK) {
            worldIn.func_175655_b(pos.func_177984_a(), true);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == Init.BAMBOO_STALK && ((Boolean)worldIn.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)THICK)).booleanValue() && !((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)THICK)).booleanValue()) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)MATURE, worldIn.func_180495_p(pos).func_177229_b((IProperty)MATURE)).func_177226_a(LEAVES, worldIn.func_180495_p(pos).func_177229_b(LEAVES)));
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (worldIn.func_180495_p(pos.func_177967_a(facing, -1)).func_177230_c() == Init.BAMBOO_STALK) {
            boolean thick = (Boolean)worldIn.func_180495_p(pos.func_177967_a(facing, -1)).func_177229_b((IProperty)THICK);
            return this.func_176223_P().func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(thick));
        }
        return this.func_176203_a(meta);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.isBlockValidForPlacement(worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
    }

    public boolean isBlockValidForPlacement(Block block) {
        return block == Blocks.field_150349_c || block instanceof BlockDirt || block == Blocks.field_150354_m || block == Blocks.field_150351_n || block == Init.BAMBOO_STALK || block == Blocks.field_150391_bh;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta > 5) {
            if (meta > 8) {
                return this.func_176223_P().func_177226_a(LEAVES, (Comparable)((Object)EnumLeaves.values()[meta - 9])).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(true));
            }
            return this.func_176223_P().func_177226_a(LEAVES, (Comparable)((Object)EnumLeaves.values()[meta - 6])).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(false));
        }
        if (meta > 2) {
            return this.func_176223_P().func_177226_a(LEAVES, (Comparable)((Object)EnumLeaves.values()[meta - 3])).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P().func_177226_a(LEAVES, (Comparable)((Object)EnumLeaves.values()[meta])).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)MATURE)).booleanValue()) {
            meta += 6;
        }
        switch ((EnumLeaves)((Object)state.func_177229_b(LEAVES))) {
            case NO_LEAVES: {
                break;
            }
            case SMALL_LEAVES: {
                ++meta;
                break;
            }
            case LARGE_LEAVES: {
                meta += 2;
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)THICK)).booleanValue()) {
            meta += 3;
        }
        return meta;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{THICK, LEAVES, MATURE});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        int j;
        int i = this.numOfAboveBamboo(worldIn, pos);
        return i + (j = this.numOfBelowBamboo(worldIn, pos)) + 1 < 16 && (Boolean)worldIn.func_180495_p(pos.func_177981_b(i)).func_177229_b((IProperty)MATURE) == false && worldIn.func_175623_d(pos.func_177981_b(i + 1));
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random random, BlockPos pos, @Nullable IBlockState state) {
        int i = this.numOfAboveBamboo(worldIn, pos);
        int j = this.numOfBelowBamboo(worldIn, pos);
        int k = i + j + 1;
        int l = 1 + random.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = pos.func_177981_b(i);
            IBlockState blockstate = worldIn.func_180495_p(blockpos);
            if (k >= 16 || ((Boolean)blockstate.func_177229_b((IProperty)MATURE)).booleanValue() || !worldIn.func_175623_d(blockpos.func_177984_a())) {
                return;
            }
            this.updateStalk(worldIn, blockpos, random, k);
            ++i;
            ++k;
        }
    }

    protected void updateStalk(World worldIn, BlockPos pos, Random random, int blocks) {
        boolean thick;
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState down2 = worldIn.func_180495_p(pos.func_177979_c(2));
        EnumLeaves leaves = EnumLeaves.NO_LEAVES;
        if (blocks >= 1) {
            if (down.func_177230_c() == Init.BAMBOO_STALK && down.func_177229_b(LEAVES) != EnumLeaves.NO_LEAVES) {
                if (down.func_177230_c() == Init.BAMBOO_STALK && down.func_177229_b(LEAVES) != EnumLeaves.NO_LEAVES) {
                    leaves = EnumLeaves.LARGE_LEAVES;
                    if (down2.func_177230_c() == Init.BAMBOO_STALK) {
                        worldIn.func_180501_a(pos.func_177977_b(), down.func_177226_a(LEAVES, (Comparable)((Object)EnumLeaves.SMALL_LEAVES)), 3);
                        worldIn.func_180501_a(pos.func_177979_c(2), down2.func_177226_a(LEAVES, (Comparable)((Object)EnumLeaves.NO_LEAVES)), 3);
                    }
                }
            } else {
                leaves = EnumLeaves.SMALL_LEAVES;
            }
        }
        boolean bl = thick = this.numOfBelowBamboo(worldIn, pos) > 2;
        if (down.func_177230_c() == Init.BAMBOO_STALK) {
            thick = this.numOfBelowBamboo(worldIn, pos) > 2 || (Boolean)down.func_177229_b((IProperty)THICK) != false;
        }
        boolean mature = !(blocks >= 11 && random.nextFloat() < 0.25f || blocks == 15);
        worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)THICK, (Comparable)Boolean.valueOf(thick)).func_177226_a(LEAVES, (Comparable)((Object)leaves)).func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf(!mature)), 3);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random random) {
        int i;
        if (!this.func_176196_c(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else if (!((Boolean)state.func_177229_b((IProperty)MATURE)).booleanValue() && random.nextInt(3) == 0 && worldIn.func_175623_d(pos.func_177984_a()) && worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.numOfBelowBamboo(worldIn, pos) + 1) < 16) {
            this.updateStalk(worldIn, pos, random, i);
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Vec3d vec3d = state.func_191059_e(worldIn, pos);
        return (Boolean)state.func_177229_b((IProperty)THICK) != false ? THICK_AABB.func_191194_a(vec3d) : THIN_AABB.func_191194_a(vec3d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_180646_a(state, worldIn, pos);
    }

    public Vec3d func_190949_e(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        long i = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        return new Vec3d(((double)((float)(i >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5, 0.0, ((double)((float)(i >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    protected int numOfAboveBamboo(World worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && worldIn.func_180495_p(pos.func_177981_b(i + 1)).func_177230_c() == Init.BAMBOO_STALK; ++i) {
        }
        return i;
    }

    protected int numOfBelowBamboo(World worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 16 && worldIn.func_180495_p(pos.func_177979_c(i + 1)).func_177230_c() == Init.BAMBOO_STALK; ++i) {
        }
        return i;
    }

    public static enum EnumLeaves implements IStringSerializable
    {
        NO_LEAVES("none"),
        SMALL_LEAVES("small"),
        LARGE_LEAVES("large");

        public String name;

        private EnumLeaves(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

