/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.futuremc.asm;

import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thedarkcolour.core.util.Util;
import thedarkcolour.futuremc.asm.CoreLoader;

public class CoreTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.world.gen.feature.WorldGenTrees")) {
            return this.patchWorldGenTrees(basicClass);
        }
        if (transformedName.equals("net.minecraft.world.gen.feature.WorldGenBigTree")) {
            return this.patchWorldGenBigTree(basicClass);
        }
        return basicClass;
    }

    private byte[] patchWorldGenTrees(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode method = classNode.methods.stream().filter(node -> node.name.equals(CoreLoader.isObfuscated ? "func_180709_b" : "generate") && node.desc.equals("(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Z")).findFirst().orElseThrow(NoSuchMethodError::new);
        InsnList toAdd = Util.make(new InsnList(), list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(21, 4));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/futuremc/world/gen/feature/BeeNestGenerator", "generateBeeNestsForSmallTrees", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/gen/feature/WorldGenAbstractTree;)V", false));
        });
        method.instructions.insertBefore(Arrays.stream(method.instructions.toArray()).filter(node -> node.getOpcode() == 172 && node.getPrevious().getOpcode() == 4).findFirst().orElseThrow(RuntimeException::new), toAdd);
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] patchWorldGenBigTree(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode method = classNode.methods.stream().filter(node -> node.name.equals(CoreLoader.isObfuscated ? "func_180709_b" : "generate") && node.desc.equals("(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Z")).findFirst().orElseThrow(NoSuchMethodError::new);
        InsnList toAdd = Util.make(new InsnList(), list -> {
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new VarInsnNode(25, 3));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/gen/feature/WorldGenBigTree", CoreLoader.isObfuscated ? "field_76501_f" : "height", "I"));
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new MethodInsnNode(184, "thedarkcolour/futuremc/world/gen/feature/BeeNestGenerator", "generateBeeNestsForBigTrees", "(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/world/gen/feature/WorldGenAbstractTree;)V", false));
        });
        method.instructions.insertBefore(Arrays.stream(method.instructions.toArray()).filter(node -> node.getOpcode() == 172 && node.getPrevious().getOpcode() == 4).findFirst().orElseThrow(RuntimeException::new), toAdd);
        ClassWriter cw = new ClassWriter(3);
        classNode.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

