/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiPredicate;

public final class PredicateArrayList<E>
extends ArrayList<E> {
    private final BiPredicate<E, E> isEquivalent;

    public PredicateArrayList(BiPredicate<E, E> isEquivalent, int initialCapacity) {
        super(initialCapacity);
        this.isEquivalent = isEquivalent;
    }

    public PredicateArrayList(BiPredicate<E, E> isEquivalent, Collection<? extends E> c) {
        super(c);
        this.isEquivalent = isEquivalent;
    }

    public PredicateArrayList(BiPredicate<E, E> isEquivalent) {
        this.isEquivalent = isEquivalent;
    }

    public boolean containsEquivalent(E obj) {
        for (Object o : this) {
            if (!this.isEquivalent.test(o, obj)) continue;
            return true;
        }
        return false;
    }

    public void removeEquivalent(E block) {
        for (Object b : this) {
            if (!this.isEquivalent.test(block, b)) continue;
            this.remove(b);
        }
    }

    public PredicateArrayList<E> bAdd(E o) {
        this.add(o);
        return this;
    }

    @SafeVarargs
    public final PredicateArrayList<E> addAll(E ... obj) {
        for (E o : obj) {
            this.add(o);
        }
        return this;
    }
}

