/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thedarkcolour.core.gui.Container;
import thedarkcolour.futuremc.FutureMC;
import thedarkcolour.futuremc.container.ContainerBarrel;
import thedarkcolour.futuremc.container.ContainerFurnaceAdvanced;
import thedarkcolour.futuremc.container.ContainerGrindstone;
import thedarkcolour.futuremc.container.ContainerLoom;
import thedarkcolour.futuremc.container.ContainerStonecutter;

public enum Gui {
    BARREL(ContainerBarrel::new),
    FURNACE(ContainerFurnaceAdvanced::new),
    GRINDSTONE(ContainerGrindstone::new),
    STONECUTTER(ContainerStonecutter::new),
    LOOM(ContainerLoom::new);

    private final ContainerSupplier<? extends Container> container;

    private <T extends Container> Gui(ContainerSupplier<T> container) {
        this.container = container;
    }

    private <T extends Container> Gui(TEContainerSupplier<T> container) {
        this.container = container;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(InventoryPlayer playerInv, World worldIn, BlockPos pos) {
        return this.getContainer(playerInv, worldIn, pos).getGuiContainer();
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(InventoryPlayer playerInv, TileEntity te) {
        return this.getContainer(playerInv, te).getGuiContainer();
    }

    public Container getContainer(InventoryPlayer playerInv, World worldIn, BlockPos pos) {
        return this.container.get(playerInv, worldIn, pos);
    }

    public Container getContainer(InventoryPlayer playerInv, TileEntity te) {
        return this.container.get(playerInv, te);
    }

    public boolean isTile() {
        return this.container instanceof TEContainerSupplier;
    }

    public void open(EntityPlayer playerIn, World worldIn, BlockPos pos) {
        playerIn.openGui((Object)FutureMC.instance, this.ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void setup() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)FutureMC.instance, (IGuiHandler)new Handler());
    }

    @FunctionalInterface
    private static interface TEContainerSupplier<T extends Container>
    extends ContainerSupplier<T> {
        @Override
        default public T get(InventoryPlayer player, World worldIn, BlockPos pos) {
            return null;
        }

        @Override
        public T get(InventoryPlayer var1, TileEntity var2);
    }

    @FunctionalInterface
    private static interface ContainerSupplier<T extends Container> {
        default public T get(InventoryPlayer player, TileEntity te) {
            return null;
        }

        public T get(InventoryPlayer var1, World var2, BlockPos var3);
    }

    private static class Handler
    implements IGuiHandler {
        private Handler() {
        }

        public Container getServerGuiElement(int ID, EntityPlayer player, World worldIn, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            Gui gui = Gui.values()[ID];
            if (gui.isTile()) {
                return gui.getContainer(player.field_71071_by, worldIn.func_175625_s(pos));
            }
            return gui.getContainer(player.field_71071_by, worldIn, pos);
        }

        public Object getClientGuiElement(int ID, EntityPlayer player, World worldIn, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            Gui gui = Gui.values()[ID];
            if (gui.isTile()) {
                return gui.getGui(player.field_71071_by, worldIn.func_175625_s(pos));
            }
            return gui.getGui(player.field_71071_by, worldIn, pos);
        }
    }
}

