/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.core.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import thedarkcolour.core.util.Util;

public final class Generator {
    public static void generate() {
        try {
            Generator.generateBlockStates();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void generateBlockStates() throws IOException {
        File folder = new File("config/futuremc/generated/blockstates/");
        folder.mkdirs();
        for (Block block : Util.make(Lists.newArrayList((Iterable)ForgeRegistries.BLOCKS.getValues()), list -> list.removeIf(block -> !block.getRegistryName().func_110624_b().equals("minecraftfuture")))) {
            File json = new File("config/futuremc/generated/blockstates/" + block.getRegistryName().func_110623_a() + ".json");
            if (json.exists()) continue;
            json.createNewFile();
            if (!json.canWrite()) {
                json.setWritable(true);
            }
            Gson gson = new GsonBuilder().disableHtmlEscaping().create();
            JsonObject obj = new JsonObject();
            JsonObject element = new JsonObject();
            ImmutableList states = block.func_176194_O().func_177619_a();
            for (IBlockState state : states) {
                String[] properties = state.func_177227_a();
                String[] names = new String[properties.size()];
                String[] values = new String[properties.size()];
                for (int i = 0; i < names.length; ++i) {
                    IProperty prop = (IProperty)properties.toArray()[i];
                    names[i] = prop.func_177701_a();
                    values[i] = ((Comparable)state.func_177228_b().get((Object)prop)).toString();
                }
                StringBuilder tagBuilder = new StringBuilder();
                for (int i = 0; i < properties.size(); ++i) {
                    if (i == properties.size() - 1) {
                        tagBuilder.append(names[i]).append("=").append(values[i]);
                        continue;
                    }
                    tagBuilder.append(names[i]).append("=").append(values[i]).append(",");
                }
                element.add(tagBuilder.toString(), (JsonElement)new JsonObject());
            }
            obj.add("variants", (JsonElement)element);
            String[] jsonText = gson.toJson((JsonElement)obj).split("[{]");
            for (int i = 0; i < jsonText.length; ++i) {
                if (jsonText[i].endsWith("}")) continue;
                int n = i;
                String string = jsonText[n] + "{";
                jsonText[n] = string;
                jsonText[i] = string;
            }
            ArrayList<String[]> linesList = new ArrayList<String[]>();
            for (String line : jsonText) {
                String[] array = line.split("},");
                for (int i = 0; i < array.length; ++i) {
                    if (i == array.length - 1) continue;
                    int n = i;
                    String string = array[n] + "},";
                    array[n] = string;
                    array[i] = string;
                }
                linesList.add(array);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(json));
            int tabs = 0;
            Iterator iterator = linesList.iterator();
            while (iterator.hasNext()) {
                String[] lines;
                for (String line : lines = (String[])iterator.next()) {
                    if (line.startsWith("}")) {
                        writer.newLine();
                        --tabs;
                    } else if (line.endsWith("{")) {
                        ++tabs;
                    }
                    for (int i = 0; i < tabs; ++i) {
                        line = "    " + line;
                    }
                    writer.write(line);
                    writer.newLine();
                }
            }
            writer.close();
        }
    }
}

