/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.chests;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import pl.asie.charset.ModCharset;
import pl.asie.charset.api.lib.IDebuggable;
import pl.asie.charset.api.lib.IMultiblockStructure;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.lib.block.Trait;
import pl.asie.charset.lib.block.TraitLockable;
import pl.asie.charset.lib.block.TraitMaterial;
import pl.asie.charset.lib.block.TraitNameable;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.inventory.IContainerHandler;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.utils.MathUtils;
import pl.asie.charset.lib.utils.MultipartUtils;
import pl.asie.charset.lib.utils.redstone.RedstoneUtils;
import pl.asie.charset.module.storage.chests.BlockChestCharset;

public class TileEntityChestCharset
extends TileBase
implements IContainerHandler,
IItemHandlerModifiable,
IMultiblockStructure,
IDebuggable,
ITickable {
    protected TraitMaterial material;
    protected final TraitLockable lockable;
    private final ItemStackHandler stacks = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityChestCharset.this.markChunkDirty();
            TileEntityChestCharset.this.updateComparators();
        }
    };
    private TileEntityChestCharset neighbor;
    private EnumFacing neighborFace;
    private float lidAngle;
    private float prevLidAngle;
    private LongSet playerIds = new LongOpenHashSet();
    private int playerCountClient;

    public TileEntityChestCharset() {
        this.material = new TraitMaterial("wood", ItemMaterialRegistry.INSTANCE.getDefaultMaterialByType("plank"));
        this.registerTrait("wood", (Trait)this.material);
        this.lockable = new TraitLockable((TileEntity)this);
        this.registerTrait("lock", (Trait)this.lockable);
        this.registerTrait("name", (Trait)new TraitNameable());
    }

    protected int getPlayerCount() {
        return this.field_145850_b != null && !this.field_145850_b.field_72995_K ? this.playerIds.size() : this.playerCountClient;
    }

    protected float getLidAngle(float partialTicks) {
        if (this.hasNeighbor() && this.neighborFace.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return MathUtils.interpolate((float)this.getNeighbor().prevLidAngle, (float)this.getNeighbor().lidAngle, (float)partialTicks);
        }
        return MathUtils.interpolate((float)this.prevLidAngle, (float)this.lidAngle, (float)partialTicks);
    }

    public TileEntityChestCharset getNeighbor() {
        if (this.neighbor == null || this.neighbor.func_145837_r()) {
            this.neighbor = null;
            if (this.neighborFace != null) {
                TileEntity tile;
                if (!this.field_145850_b.field_72995_K) {
                    if (this.field_145850_b != null && this.field_174879_c != null) {
                        TileEntity tile2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.neighborFace));
                        if (tile2 instanceof TileEntityChestCharset && !tile2.func_145837_r()) {
                            this.setNeighbor((TileEntityChestCharset)tile2, this.neighborFace);
                        } else {
                            this.setNeighbor(null, null);
                        }
                    }
                } else if (this.field_145850_b != null && this.field_174879_c != null && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.neighborFace))) instanceof TileEntityChestCharset && !tile.func_145837_r()) {
                    this.neighbor = (TileEntityChestCharset)tile;
                }
            }
        }
        return this.neighbor;
    }

    public EnumFacing getNeighborFace() {
        return this.neighborFace;
    }

    public boolean hasNeighbor() {
        return this.neighborFace != null && this.getNeighbor() != null;
    }

    public int getComparatorValue(int max) {
        return RedstoneUtils.getComparatorValue((IItemHandler)this, (int)max);
    }

    public void func_73660_a() {
        super.update();
        this.prevLidAngle = this.lidAngle;
        int pc = this.getPlayerCount();
        this.lidAngle = pc > 0 ? Math.min(1.0f, this.lidAngle + (this.hasNeighbor() ? 0.08f : 0.1f)) : Math.max(0.0f, this.lidAngle - (this.hasNeighbor() ? 0.08f : 0.1f));
    }

    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        super.readNBTData(compound, isClient);
        if (!isClient && compound.func_74764_b("inv")) {
            this.stacks.deserializeNBT(compound.func_74775_l("inv"));
        }
        EnumFacing oldNF = this.neighborFace;
        EnumFacing enumFacing = this.neighborFace = compound.func_150297_b("nf", 99) ? EnumFacing.func_82600_a((int)compound.func_74771_c("nf")) : null;
        if (oldNF != this.neighborFace && isClient) {
            this.markBlockForRenderUpdate();
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound = super.writeNBTData(compound, isClient);
        if (!isClient) {
            NBTTagCompound invTag = this.stacks.serializeNBT();
            compound.func_74782_a("inv", (NBTBase)invTag);
        }
        if (this.neighborFace != null) {
            compound.func_74774_a("nf", (byte)this.neighborFace.ordinal());
        }
        return compound;
    }

    public void getDrops(NonNullList<ItemStack> stackList, IBlockState state, int fortune, boolean silkTouch) {
        stackList.add((Object)this.getDroppedBlock(state));
        for (int i = 0; i < this.stacks.getSlots(); ++i) {
            ItemStack s = this.stacks.getStackInSlot(i);
            if (s.func_190926_b()) continue;
            stackList.add((Object)s);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == Capabilities.MULTIBLOCK_STRUCTURE || capability == Capabilities.DEBUGGABLE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == Capabilities.MULTIBLOCK_STRUCTURE) {
            return (T)Capabilities.MULTIBLOCK_STRUCTURE.cast((Object)this);
        }
        if (capability == Capabilities.DEBUGGABLE) {
            return (T)Capabilities.DEBUGGABLE.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isBlocked() {
        if (MultipartUtils.INSTANCE.intersects(Collections.singleton(new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0)), (IBlockAccess)this.field_145850_b, this.field_174879_c, s -> !(s.func_177230_c() instanceof BlockChestCharset))) {
            return true;
        }
        BlockPos posUp = this.field_174879_c.func_177984_a();
        if (this.field_145850_b.func_180495_p(posUp).doesSideBlockChestOpening((IBlockAccess)this.field_145850_b, posUp, EnumFacing.DOWN)) {
            return true;
        }
        for (EntityOcelot ocelot : this.field_145850_b.func_72872_a(EntityOcelot.class, new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, 0), this.field_174879_c.func_177982_a(1, 2, 1)))) {
            if (!ocelot.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public boolean activate(EntityPlayer player, EnumFacing side, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b().getToolClasses(stack).contains("wrench")) {
            boolean attached = false;
            BlockPos otherPos = this.field_174879_c.func_177972_a(side);
            TileEntity otherTile = this.field_145850_b.func_175625_s(otherPos);
            if (otherTile instanceof TileEntityChestCharset && ((TileEntityChestCharset)otherTile).material.getMaterial() == this.material.getMaterial() && !((TileEntityChestCharset)otherTile).hasNeighbor()) {
                attached = true;
                this.setNeighbor((TileEntityChestCharset)otherTile, side);
                player.func_184609_a(hand);
            }
            if (this.hasNeighbor() && !attached) {
                this.neighbor.setNeighbor(null, null);
                this.setNeighbor(null, null);
                player.func_184609_a(hand);
            }
            return true;
        }
        if (this.isBlocked() || this.hasNeighbor() && this.getNeighbor().isBlocked()) {
            return true;
        }
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)ModCharset.instance, 260, this.func_145831_w(), this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            player.func_71029_a(StatList.field_188063_ac);
        }
        return true;
    }

    private IItemHandlerModifiable ihFirstHandler() {
        return this.neighborFace != null && this.neighborFace.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? this.neighbor.stacks : this.stacks;
    }

    private IItemHandlerModifiable ihSecondHandler() {
        return this.neighborFace != null && this.neighborFace.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.neighbor.stacks : this.stacks;
    }

    private int ihSlot(int slot) {
        if (slot >= this.ihFirstHandler().getSlots()) {
            return slot - this.ihFirstHandler().getSlots();
        }
        return slot;
    }

    private IItemHandlerModifiable ihHandler(int slot) {
        if (slot >= this.ihFirstHandler().getSlots()) {
            return this.ihSecondHandler();
        }
        return this.ihFirstHandler();
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.getTraitDisplayName((ITextComponent)new TextComponentTranslation(this.hasNeighbor() ? "container.chestDouble" : "container.chest", new Object[0]));
    }

    public int getSlots() {
        return this.hasNeighbor() ? this.neighbor.stacks.getSlots() + this.stacks.getSlots() : this.stacks.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.ihHandler(slot).getStackInSlot(this.ihSlot(slot));
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.ihHandler(slot).insertItem(this.ihSlot(slot), stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.ihHandler(slot).extractItem(this.ihSlot(slot), amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.ihHandler(slot).getSlotLimit(this.ihSlot(slot));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.ihHandler(slot).setStackInSlot(this.ihSlot(slot), stack);
    }

    public Iterator<BlockPos> iterator() {
        return this.hasNeighbor() ? ImmutableList.of((Object)this.field_174879_c, (Object)this.neighbor.field_174879_c).iterator() : ImmutableList.of((Object)this.field_174879_c).iterator();
    }

    public boolean contains(BlockPos pos) {
        if (pos.equals((Object)this.field_174879_c)) {
            return true;
        }
        return this.hasNeighbor() && this.getNeighbor().field_174879_c.equals((Object)pos);
    }

    protected void setNeighbor(TileEntityChestCharset tile, EnumFacing facing) {
        this.neighbor = tile;
        this.neighborFace = facing;
        this.markBlockForUpdate();
        this.func_70296_d();
        if (tile != null) {
            tile.neighbor = this;
            tile.neighborFace = facing.func_176734_d();
            tile.markBlockForUpdate();
            tile.func_70296_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.hasNeighbor()) {
            return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
        }
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 0, 0), this.field_174879_c.func_177982_a(1, 2, 1));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void addDebugInformation(List<String> stringList, Side side) {
        this.getNeighbor();
        stringList.add("Neighbor: " + (this.neighborFace != null ? this.neighborFace.name() : "none"));
    }

    public boolean func_145842_c(int id, int type) {
        switch (id) {
            case 1: {
                this.playerCountClient = type;
                return true;
            }
        }
        return super.func_145842_c(id, type);
    }

    private void playChestSound(SoundEvent event) {
        float pitch = this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f;
        Vec3d pos = new Vec3d((Vec3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
        if (this.hasNeighbor()) {
            pos = pos.func_72441_c((double)this.neighborFace.func_82601_c() * 0.5, (double)this.neighborFace.func_96559_d() * 0.5, (double)this.neighborFace.func_82599_e() * 0.5);
            pitch *= 0.85f;
        }
        this.field_145850_b.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, event, SoundCategory.BLOCKS, 0.5f, pitch);
    }

    public void onOpenedBy(EntityPlayer player) {
        this.onOpenedByInner(player);
        if (this.hasNeighbor()) {
            this.getNeighbor().onOpenedByInner(player);
        }
    }

    public void onClosedBy(EntityPlayer player) {
        this.onClosedByInner(player);
        if (this.hasNeighbor()) {
            this.getNeighbor().onClosedByInner(player);
        }
    }

    protected void onOpenedByInner(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (!this.playerIds.add((long)player.func_145782_y())) {
                return;
            }
            if (!(this.hasNeighbor() && this.neighborFace.func_176743_c() != EnumFacing.AxisDirection.NEGATIVE || this.playerIds.size() != 1)) {
                this.playChestSound(SoundEvents.field_187657_V);
            }
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.playerIds.size());
        }
    }

    protected void onClosedByInner(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (!this.playerIds.remove((long)player.func_145782_y())) {
                return;
            }
            if (!(this.hasNeighbor() && this.neighborFace.func_176743_c() != EnumFacing.AxisDirection.NEGATIVE || this.playerIds.size() != 0)) {
                this.playChestSound(SoundEvents.field_187651_T);
            }
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, this.playerIds.size());
        }
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }
}

