/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.chests;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.item.ItemBlockBase;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.module.storage.chests.TileEntityChestCharset;

public class ItemBlockChestCharset
extends ItemBlockBase {
    public ItemBlockChestCharset(Block block) {
        super(block);
        this.func_77655_b("chest");
    }

    public String func_77653_i(ItemStack is) {
        Optional s = ItemMaterialRegistry.INSTANCE.getLocalizedNameFor(ItemMaterialRegistry.INSTANCE.getMaterial(is.func_77978_p(), "wood"));
        String baseName = I18n.func_74838_a((String)(this.func_77667_c(is) + ".name"));
        return s.map(s1 -> I18n.func_74837_a((String)"tile.charset.chest.format", (Object[])new Object[]{s1, baseName})).orElse(baseName);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntityChestCharset chest = (TileEntityChestCharset)newState.func_177230_c().createTileEntity(world, newState);
        chest.func_145834_a(world);
        chest.func_174878_a(pos);
        chest.loadFromStack(stack);
        BlockPos neighborPos = null;
        EnumFacing neighborFacing = null;
        TileEntityChestCharset neighbor = null;
        if (player.func_70093_af()) {
            BlockPos otherPos;
            TileEntity otherTile;
            if (side.func_176740_k() != EnumFacing.Axis.Y && (otherTile = world.func_175625_s(otherPos = pos.func_177972_a(side.func_176734_d()))) instanceof TileEntityChestCharset && ((TileEntityChestCharset)otherTile).material.getMaterial() == chest.material.getMaterial()) {
                if (((TileEntityChestCharset)otherTile).hasNeighbor()) {
                    return false;
                }
                neighborPos = otherPos;
                neighborFacing = side.func_176734_d();
                neighbor = (TileEntityChestCharset)otherTile;
            }
        } else {
            for (BlockPos facing : EnumFacing.field_176754_o) {
                BlockPos otherPos = pos.func_177972_a((EnumFacing)facing);
                TileEntity otherTile = world.func_175625_s(otherPos);
                if (!(otherTile instanceof TileEntityChestCharset) || ((TileEntityChestCharset)otherTile).material.getMaterial() != chest.material.getMaterial() || neighborPos != null || ((TileEntityChestCharset)otherTile).hasNeighbor()) continue;
                neighborPos = otherPos;
                neighborFacing = facing;
                neighbor = (TileEntityChestCharset)otherTile;
            }
        }
        if (neighborPos != null) {
            EnumFacing selfFacing = player.func_174811_aO().func_176734_d();
            if (neighborFacing.func_176740_k() == selfFacing.func_176740_k()) {
                selfFacing = selfFacing.func_176746_e();
            }
            world.func_180501_a(neighborPos, world.func_180495_p(neighborPos).func_177226_a((IProperty)Properties.FACING4, (Comparable)selfFacing), 2);
            newState = newState.func_177226_a((IProperty)Properties.FACING4, (Comparable)selfFacing);
        }
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            if (neighborPos != null) {
                neighbor.setNeighbor((TileEntityChestCharset)world.func_175625_s(pos), neighborFacing.func_176734_d());
            }
            return true;
        }
        return false;
    }
}

