/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.chests;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.inventory.GuiHandlerCharset;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.recipe.RecipeDummy;
import pl.asie.charset.lib.recipe.RecipePatchwork;
import pl.asie.charset.lib.render.sprite.TextureWhitener;
import pl.asie.charset.lib.resources.CharsetFakeResourcePack;
import pl.asie.charset.lib.utils.RegistryUtils;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.module.storage.chests.BlockChestCharset;
import pl.asie.charset.module.storage.chests.ContainerChestCharset;
import pl.asie.charset.module.storage.chests.CustomCarryHandlerChest;
import pl.asie.charset.module.storage.chests.GuiChestCharset;
import pl.asie.charset.module.storage.chests.ItemBlockChestCharset;
import pl.asie.charset.module.storage.chests.ModelChestCharset;
import pl.asie.charset.module.storage.chests.TileEntityChestCharset;
import pl.asie.charset.module.storage.chests.TileEntityChestRendererCharset;

@CharsetModule(name="storage.chests", description="Chests out of any wood!", profile=ModuleProfile.FORCED)
public class CharsetStorageChests {
    @CharsetModule.Configuration
    public static Configuration config;
    private static boolean disableVanillaChestRecipe;
    public static BlockChestCharset blockChest;
    public static ItemBlock itemChest;

    @Mod.EventHandler
    public void loadConfig(CharsetLoadConfigEvent event) {
        disableVanillaChestRecipe = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"disableVanillaChestRecipe", (boolean)true, (String)"Disable the vanilla chest recipe. May cause issues with auto-crafting mods which do not expect single-wood requirements in an IRecipe.", (boolean)true);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        blockChest = new BlockChestCharset();
        itemChest = new ItemBlockChestCharset((Block)blockChest);
        CapabilityHelper.registerBlockProvider((Capability)Capabilities.CUSTOM_CARRY_PROVIDER, (Block)blockChest, (a, b, c, d) -> CustomCarryHandlerChest::new);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        RecipePatchwork patchwork = new RecipePatchwork(stack -> {
            if (stack.func_77973_b() == itemChest) {
                return new ItemStack((Block)Blocks.field_150486_ae);
            }
            return stack;
        });
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)patchwork, (String)"replace_chest");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        OreDictionary.registerOre((String)"chest", (Item)itemChest);
        OreDictionary.registerOre((String)"chestWood", (Item)itemChest);
        if (disableVanillaChestRecipe) {
            for (IRecipe recipe : CraftingManager.field_193380_a) {
                ItemStack output = recipe.func_77571_b();
                if (output.func_190926_b() || output.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150486_ae)) continue;
                ForgeRegistries.RECIPES.register(new RecipeDummy(recipe.func_193358_e()).setRegistryName(recipe.getRegistryName()));
                ModCharset.logger.info("Disabled " + ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)output.func_77973_b())).toString() + " (removed recipe)");
            }
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        this.addFakeTexture(new ResourceLocation("minecraft:entity/chest/normal"), TileEntityChestRendererCharset.TEXTURE_NORMAL, (x, y) -> x.floatValue() >= 0.21875f || y.floatValue() >= 0.21875f);
        this.addFakeTexture(new ResourceLocation("minecraft:entity/chest/normal_double"), TileEntityChestRendererCharset.TEXTURE_NORMAL_DOUBLE, (x, y) -> x.floatValue() >= 0.109375f || y.floatValue() >= 0.21875f);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        RegistryUtils.register(TileEntityChestCharset.class, (String)"chest");
        FMLInterModComms.sendMessage((String)"charset", (String)"addCarry", (ResourceLocation)blockChest.getRegistryName());
        GuiHandlerCharset.INSTANCE.register(260, Side.SERVER, r -> {
            TileEntity tile = r.getTileEntity();
            if (tile instanceof TileEntityChestCharset) {
                return new ContainerChestCharset((TileEntityChestCharset)tile, r.player.field_71071_by);
            }
            return null;
        });
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        GuiHandlerCharset.INSTANCE.register(260, Side.CLIENT, r -> new GuiChestCharset((ContainerChestCharset)r.getContainer(ContainerChestCharset.class)));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityChestCharset.class, (TileEntitySpecialRenderer)TileEntityChestRendererCharset.INSTANCE);
        ForgeHooksClient.registerTESRItemStack((Item)itemChest, (int)0, TileEntityChestCharset.class);
        itemChest.setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new TileEntityChestRendererCharset.Stack());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegistry(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)itemChest, (int)0, (ModelResourceLocation)new ModelResourceLocation("minecraft:chest", "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private void overrideChestModel(ModelBakeEvent event, String variant) {
        IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)new ModelResourceLocation("minecraft:chest", variant));
        if (model == null) {
            model = ModelLoaderRegistry.getMissingModel().bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
        }
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charset:chest", variant), (Object)new ModelChestCharset(model));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        this.overrideChestModel(event, "facing=west");
        this.overrideChestModel(event, "facing=east");
        this.overrideChestModel(event, "facing=north");
        this.overrideChestModel(event, "facing=south");
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)blockChest, (String)"chest");
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        RegistryUtils.register((IForgeRegistry)event.getRegistry(), (IForgeRegistryEntry)itemChest, (String)"chest");
    }

    @SideOnly(value=Side.CLIENT)
    private void addFakeTexture(ResourceLocation from, ResourceLocation res, BiPredicate<Float, Float> usePixel) {
        CharsetFakeResourcePack.INSTANCE.registerEntry(res, stream -> {
            BufferedImage image = RenderUtils.getTextureImage((ResourceLocation)from, (Function)ModelLoader.defaultTextureGetter());
            int[] pixels = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
            TextureWhitener.INSTANCE.remap(pixels, image.getWidth(), ModelLoader.defaultTextureGetter(), from, -1, usePixel, 1.0f, false);
            image.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
            try {
                ImageIO.write((RenderedImage)image, "png", stream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

