/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.storage.chests;

import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.item.SubItemProviderCache;
import pl.asie.charset.lib.item.SubItemProviderRecipes;
import pl.asie.charset.lib.item.SubItemSetHelper;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.utils.UnlistedPropertyGeneric;
import pl.asie.charset.module.storage.chests.CharsetStorageChests;
import pl.asie.charset.module.storage.chests.TileEntityChestCharset;

public class BlockChestCharset
extends BlockBase
implements ITileEntityProvider {
    protected static final IUnlistedProperty<ItemMaterial> MATERIAL_PROP = new UnlistedPropertyGeneric("material", ItemMaterial.class);
    protected static final AxisAlignedBB[] FACING_BOXES = new AxisAlignedBB[6];

    public BlockChestCharset() {
        super(Material.field_151575_d);
        this.setFullCube(false);
        this.setOpaqueCube(false);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("chest");
    }

    protected ISubItemProvider createSubItemProvider() {
        return new SubItemProviderCache((ISubItemProvider)new SubItemProviderRecipes(() -> CharsetStorageChests.itemChest){

            protected int compareSets(List<ItemStack> first, List<ItemStack> second) {
                return SubItemSetHelper.wrapLists(first, second, (Comparator)SubItemSetHelper.extractMaterial((String)"wood", SubItemSetHelper::sortByItem));
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        if (state instanceof IExtendedBlockState && (tile = world.func_175625_s(pos)) instanceof TileEntityChestCharset) {
            return ((IExtendedBlockState)state).withProperty(MATERIAL_PROP, (Object)((TileEntityChestCharset)tile).material.getMaterial());
        }
        return state;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int id = 0;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityChestCharset && ((TileEntityChestCharset)tile).hasNeighbor()) {
            id = ((TileEntityChestCharset)tile).getNeighborFace().ordinal();
        }
        return FACING_BOXES[id];
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)Properties.FACING4, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityChestCharset) {
            ((TileEntityChestCharset)tile).getNeighbor();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (world != null && (tile = world.func_175625_s(pos)) instanceof TileEntityChestCharset) {
            return ((TileEntityChestCharset)tile).activate(player, side, hand);
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{Properties.FACING4}, new IUnlistedProperty[]{MATERIAL_PROP});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING4)).ordinal() - 2;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING4, (Comparable)EnumFacing.func_82600_a((int)((meta & 3) + 2)));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityChestCharset();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING4);
        EnumFacing newFacing = axis == EnumFacing.DOWN ? facing.func_176735_f() : facing.func_176746_e();
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityChestCharset)) {
            return false;
        }
        if (((TileEntityChestCharset)tile).hasNeighbor()) {
            BlockPos otherPos = ((TileEntityChestCharset)tile).getNeighbor().func_174877_v();
            IBlockState otherState = world.func_180495_p(otherPos);
            EnumFacing otherFacing = (EnumFacing)otherState.func_177229_b((IProperty)Properties.FACING4);
            if (facing != otherFacing) {
                return false;
            }
            newFacing = facing.func_176746_e().func_176746_e();
            world.func_175656_a(otherPos, otherState.func_177226_a((IProperty)Properties.FACING4, (Comparable)newFacing));
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)Properties.FACING4, (Comparable)newFacing));
        return true;
    }

    static {
        BlockChestCharset.FACING_BOXES[0] = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
        BlockChestCharset.FACING_BOXES[1] = FACING_BOXES[0];
        BlockChestCharset.FACING_BOXES[2] = new AxisAlignedBB(0.0625, 0.0, 0.0, 0.9375, 0.875, 0.9375);
        BlockChestCharset.FACING_BOXES[3] = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 1.0);
        BlockChestCharset.FACING_BOXES[4] = new AxisAlignedBB(0.0, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
        BlockChestCharset.FACING_BOXES[5] = new AxisAlignedBB(0.0625, 0.0, 0.0625, 1.0, 0.875, 0.9375);
    }
}

