/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import de.erdbeerbaerlp.guilib.components.GuiComponent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class Image
extends GuiComponent {
    private final DynamicTexture image;
    private final ResourceLocation resLoc;
    private Runnable callback;
    private String errorTooltip = "";

    public Image(int x, int y, int width, int height, String imageURL) {
        super(x, y, width, height);
        BufferedImage img;
        try {
            img = this.loadImageFromURL(imageURL);
        }
        catch (IOException e) {
            this.errorTooltip = e.getCause() == null ? e.getClass().getCanonicalName() + ": " + e.getMessage() : e.getCause().getLocalizedMessage();
            this.image = null;
            this.resLoc = null;
            return;
        }
        this.image = new DynamicTexture(img);
        this.resLoc = null;
    }

    public Image(int x, int y, int width, int height, URL imageURL) {
        this(x, y, width, height, imageURL.toString());
    }

    public Image(int x, int y, int width, int height, File imageFile) {
        super(x, y, width, height);
        BufferedImage img;
        try {
            img = ImageIO.read(imageFile);
        }
        catch (IOException e) {
            this.errorTooltip = e.getCause() == null ? e.getClass().getCanonicalName() + ": " + e.getMessage() : e.getCause().getLocalizedMessage();
            this.image = null;
            this.resLoc = null;
            return;
        }
        this.image = new DynamicTexture(img);
        this.resLoc = null;
    }

    public Image(int x, int y, int width, int height, ResourceLocation resourceLocation) {
        super(x, y, width, height);
        this.image = null;
        this.resLoc = resourceLocation;
    }

    @Override
    public String[] getTooltips() {
        if (this.image == null && this.resLoc == null) {
            return (String[])ArrayUtils.addAll((Object[])super.getTooltips(), (Object[])new String[]{"", "\u00c2\u00a7cError loading image:", "\u00c2\u00a7c" + this.errorTooltip});
        }
        return super.getTooltips();
    }

    public void setCallback(Runnable callback) {
        this.callback = callback;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            if (this.image == null && this.resLoc != null) {
                this.mc.func_110434_K().func_110577_a(this.resLoc);
                Image.func_146110_a((int)this.getX(), (int)this.getY(), (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (float)this.getWidth(), (float)this.getHeight());
            } else if (this.image != null && this.resLoc == null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.mc.field_71446_o.func_110578_a("image", this.image));
                Image.func_146110_a((int)this.getX(), (int)this.getY(), (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (float)this.getWidth(), (float)this.getHeight());
            } else {
                this.mc.func_110434_K().func_110577_a(errorIcon);
                Image.func_146110_a((int)(this.getX() + this.getWidth() / 2), (int)(this.getY() + this.getHeight() / 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
        }
    }

    public void onClick() {
        if (this.callback != null) {
            this.callback.run();
        }
    }

    private boolean mousePressed(int mouseX, int mouseY) {
        return this.visible && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
    }

    @Override
    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.mousePressed(mouseX, mouseY) && this.enabled && this.visible) {
            this.onClick();
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }
}

