/*
 * Decompiled with CFR 0.152.
 */
package de.erdbeerbaerlp.guilib.components;

import de.erdbeerbaerlp.guilib.components.Slider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;

public class EnumSlider
extends Slider {
    private Runnable action;
    private Enum<?> enumValue;
    private Enum<?>[] enumValues;
    private int prevIndex;

    public <T extends Enum<T>> EnumSlider(int xPos, int yPos, String prefix, Class<T> enumClass, T currentVal, Runnable changeAction) {
        this(xPos, yPos, 150, 20, prefix, "", enumClass, currentVal, true, changeAction);
    }

    public <T extends Enum<T>> EnumSlider(int xPos, int yPos, int width, int height, String prefix, String suf, Class<T> enumClass, T currentVal, boolean drawStr) {
        this(xPos, yPos, width, height, prefix, suf, enumClass, currentVal, drawStr, null);
    }

    public <T extends Enum<T>> EnumSlider(int xPos, int yPos, int width, int height, String prefix, String suf, Class<T> enumClass, T currentVal, boolean drawStr, Runnable changeAction) {
        super(xPos, yPos, width, height, prefix, suf, -1.0, -1.0, -1.0, false, drawStr, null);
        this.action = changeAction;
        this.enumValue = currentVal;
        this.enumValues = (Enum[])enumClass.getEnumConstants();
        this.maxValue = this.enumValues.length;
        this.showDecimal = false;
        this.minValue = 0.0;
        this.sliderValue = ((double)this.getCurrentIndex() - this.minValue) / (this.maxValue - this.minValue);
        String val = "";
        for (Method m : this.enumValue.getClass().getMethods()) {
            if (!m.getName().equals("getName") || m.getParameterTypes().length != 0 || m.getReturnType() != String.class) continue;
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            try {
                val = (String)m.invoke(this.enumValue, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.displayString = this.dispString + (val.isEmpty() ? this.enumValue.name() : val) + this.suffix;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.displayString = "";
        }
    }

    public Enum<?> getEnum() {
        return this.enumValue;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partial) {
        super.draw(mouseX, mouseY, partial);
    }

    @Override
    public void updateSlider() {
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        String val = this.enumValue.name();
        for (Method m : this.enumValue.getClass().getMethods()) {
            if (!m.getName().equals("getName") || m.getParameterTypes().length != 0 || m.getReturnType() != String.class) continue;
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            try {
                val = (String)m.invoke(this.enumValue, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (this.drawString) {
            this.displayString = this.dispString + val + this.suffix;
        }
        if (this.prevIndex != this.getCurrentIndex()) {
            this.onValueChanged();
        }
    }

    @Override
    public void onValueChanged() {
        if (this.action != null) {
            this.action.run();
        }
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.prevIndex = this.getCurrentIndex();
        if (this.visible) {
            if (this.dragging) {
                int index = this.getCurrentIndex();
                this.sliderValue = (float)(mouseX - (this.getX() + 4)) / (float)(this.width - 8);
                int sliderValue = (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
                if (sliderValue < 0) {
                    sliderValue = 0;
                }
                if (index == -1) {
                    this.enumValue = this.enumValues[0];
                } else if (sliderValue < this.enumValues.length) {
                    this.enumValue = this.enumValues[sliderValue];
                }
                this.updateSlider();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.getX() + (int)(this.sliderValue * (double)(this.width - 8)), this.getY(), 0, 66, 4, 20);
            this.func_73729_b(this.getX() + (int)(this.sliderValue * (double)(this.width - 8)) + 4, this.getY(), 196, 66, 4, 20);
        }
    }

    @Override
    public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
        if (this.superMousePressed(par2, par3)) {
            int index = this.getCurrentIndex();
            this.playPressSound();
            this.sliderValue = (float)(par2 - (this.getX() + 4)) / (float)(this.width - 8);
            int sliderValue = (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (sliderValue < 0) {
                return false;
            }
            if (index == -1) {
                this.enumValue = this.enumValues[0];
            } else if (sliderValue < this.enumValues.length) {
                this.enumValue = this.enumValues[sliderValue];
            }
            this.updateSlider();
            this.dragging = true;
            return true;
        }
        return false;
    }

    private int getCurrentIndex() {
        int out = 0;
        for (Enum<?> e : this.enumValues) {
            if (e.name().equals(this.enumValue.name())) {
                return out;
            }
            ++out;
        }
        return -1;
    }

    protected boolean superMousePressed(int mouseX, int mouseY) {
        return this.enabled && this.visible && mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
    }

    @Override
    public void mouseClick(int mouseX, int mouseY, int mouseButton) {
        this.prevIndex = this.getCurrentIndex();
        if (this.mousePressed(this.mc, mouseX, mouseY)) {
            this.playPressSound();
        }
    }
}

