/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.util.nbt;

import com.google.common.collect.Lists;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.nbt.NBTConversionHandler;
import com.ldtteam.jvoxelizer.util.nbt.INBTBase;
import com.ldtteam.jvoxelizer.util.nbt.INBTList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.NotNull;

public class NBTList
implements INBTList {
    private final NBTTagList forgeNbtList;

    private NBTList(NBTTagList forgeNbtList) {
        this.forgeNbtList = forgeNbtList;
    }

    public byte getType() {
        return this.forgeNbtList.func_74732_a();
    }

    public int size() {
        return this.forgeNbtList.func_74745_c();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        if (!(o instanceof INBTBase)) {
            return false;
        }
        return this.toList().contains(o);
    }

    @NotNull
    public Iterator<INBTBase> iterator() {
        return this.toList().iterator();
    }

    @NotNull
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.toList().toArray(a);
    }

    public boolean add(INBTBase inbtBase) {
        this.forgeNbtList.func_74742_a(NBTConversionHandler.toNbtBase(inbtBase));
        return true;
    }

    public boolean remove(Object o) {
        int index = this.toList().indexOf(o);
        if (index == -1) {
            return false;
        }
        this.forgeNbtList.func_74744_a(index);
        return true;
    }

    public boolean containsAll(@NotNull Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    public boolean addAll(@NotNull Collection<? extends INBTBase> c) {
        return c.stream().anyMatch(this::add);
    }

    public boolean removeAll(@NotNull Collection<?> c) {
        return c.stream().anyMatch(this::remove);
    }

    public boolean retainAll(@NotNull Collection<?> c) {
        boolean changed = false;
        Iterator iterator = this.forgeNbtList.iterator();
        while (iterator.hasNext()) {
            if (c.contains(NBTConversionHandler.toINbtBase((NBTBase)iterator.next()))) continue;
            changed = true;
            iterator.remove();
        }
        return changed;
    }

    public void clear() {
        this.removeAll(this.toList());
    }

    private List<INBTBase> toList() {
        ArrayList list = Lists.newArrayList();
        this.forgeNbtList.forEach(nbt -> list.add(NBTConversionHandler.toINbtBase(nbt)));
        return list;
    }

    public static INBTList fromForge(NBTTagList list) {
        return new NBTList(list);
    }

    public static NBTTagList asForge(INBTList list) {
        return ((NBTList)list).forgeNbtList;
    }
}

