/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.networking.endpoint;

import com.ldtteam.jvoxelizer.entity.living.player.IMultiplayerPlayerEntity;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.core.IForgeJVoxelizerWrapper;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.entity.living.player.MultiplayerPlayerEntity;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.networking.messaging.JVoxMessageWrapper;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.networking.messaging.JVoxMessageWrapperHandler;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.networking.utils.target.NetworkTargetPoint;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.threading.Executor;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.distribution.executor.DistributionExecutor;
import com.ldtteam.jvoxelizer.networking.endpoint.INetworkEndpoint;
import com.ldtteam.jvoxelizer.networking.messaging.IMessageContext;
import com.ldtteam.jvoxelizer.networking.utils.target.INetworkTargetPoint;
import com.ldtteam.jvoxelizer.threading.IExecutor;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class NetworkEndpoint
implements INetworkEndpoint,
IForgeJVoxelizerWrapper {
    private SimpleNetworkWrapper manager;

    private NetworkEndpoint(SimpleNetworkWrapper manager) {
        this.manager = manager;
        this.manager.registerMessage(JVoxMessageWrapperHandler.class, JVoxMessageWrapper.class, 0, Side.CLIENT);
        this.manager.registerMessage(JVoxMessageWrapperHandler.class, JVoxMessageWrapper.class, 1, Side.SERVER);
    }

    public void sendToAll(com.ldtteam.jvoxelizer.networking.messaging.IMessage message) {
        this.manager.sendToAll((IMessage)new JVoxMessageWrapper(message));
    }

    public void sendTo(com.ldtteam.jvoxelizer.networking.messaging.IMessage message, IMultiplayerPlayerEntity player) {
        this.manager.sendTo((IMessage)new JVoxMessageWrapper(message), MultiplayerPlayerEntity.asForge(player));
    }

    public void sendToAllAround(com.ldtteam.jvoxelizer.networking.messaging.IMessage message, INetworkTargetPoint point) {
        this.manager.sendToAllAround((IMessage)new JVoxMessageWrapper(message), NetworkTargetPoint.asForge(point));
    }

    public void sendToDimension(com.ldtteam.jvoxelizer.networking.messaging.IMessage message, int dimensionId) {
        this.manager.sendToDimension((IMessage)new JVoxMessageWrapper(message), dimensionId);
    }

    public void sendToServer(com.ldtteam.jvoxelizer.networking.messaging.IMessage message) {
        this.manager.sendToServer((IMessage)new JVoxMessageWrapper(message));
    }

    public IExecutor getExecutorFromContext(IMessageContext context) {
        Supplier threadListenerSuplier = DistributionExecutor.getInstance().runOn(() -> new Supplier<IThreadListener>(){

            @Override
            public IThreadListener get() {
                return Minecraft.func_71410_x();
            }
        }, () -> new Supplier<IThreadListener>(){

            @Override
            public IThreadListener get() {
                return FMLCommonHandler.instance().getMinecraftServerInstance();
            }
        });
        IThreadListener threadListener = (IThreadListener)threadListenerSuplier.get();
        return Executor.fromForge(threadListener);
    }

    private SimpleNetworkWrapper getManager() {
        return this.manager;
    }

    public static SimpleNetworkWrapper asForge(INetworkEndpoint endpoint) {
        if (endpoint instanceof SimpleNetworkWrapper) {
            return (SimpleNetworkWrapper)endpoint;
        }
        if (endpoint == null) {
            return null;
        }
        if (!(endpoint instanceof IForgeJVoxelizerWrapper)) {
            throw new IllegalArgumentException("Endpoint is not a wrapper");
        }
        return (SimpleNetworkWrapper)((IForgeJVoxelizerWrapper)endpoint).getForgeInstance();
    }

    public static INetworkEndpoint fromForge(SimpleNetworkWrapper networkWrapper) {
        if (networkWrapper instanceof INetworkEndpoint) {
            return (INetworkEndpoint)networkWrapper;
        }
        return new NetworkEndpoint(networkWrapper);
    }

    @Override
    public <T> T getForgeInstance() {
        return (T)this.getManager();
    }
}

