/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.event.handler;

import com.google.common.collect.Maps;
import com.ldtteam.jvoxelizer.common.gameevent.event.ITickEvent;
import com.ldtteam.jvoxelizer.common.gameevent.event.player.IPlayerGameEvent;
import com.ldtteam.jvoxelizer.event.IEvent;
import com.ldtteam.jvoxelizer.event.handler.IEventHandlerManagerProvider;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.event.handler.handlers.ClientTickEventHandler;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.event.handler.handlers.PlayerLoggedOutEventHandler;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.event.handler.handlers.ServerTickEventHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;

public class EventHandlerManagerProvider
implements IEventHandlerManagerProvider {
    private static EventHandlerManagerProvider ourInstance = new EventHandlerManagerProvider();
    private final Map<Class<?>, List<Consumer<? extends IEvent>>> handlers = Maps.newHashMap();
    private final Map<Class<?>, Object> knownEventHandlers = Maps.newHashMap();

    public static EventHandlerManagerProvider getInstance() {
        return ourInstance;
    }

    private EventHandlerManagerProvider() {
        this.knownEventHandlers.put(IPlayerGameEvent.ILoggedOutEvent.class, new PlayerLoggedOutEventHandler());
        this.knownEventHandlers.put(ITickEvent.IClientTickEvent.class, new ClientTickEventHandler());
        this.knownEventHandlers.put(ITickEvent.IServerTickEvent.class, new ServerTickEventHandler());
    }

    public <T extends IEvent> void registerHandler(Class<T> handledType, Consumer<T> handler) {
        if (this.knownEventHandlers.containsKey(handledType)) {
            MinecraftForge.EVENT_BUS.register(this.knownEventHandlers.remove(handledType));
        }
        this.handlers.putIfAbsent(handledType, new ArrayList());
        this.handlers.get(handledType).add(handler);
    }

    public Map<Class<?>, List<Consumer<? extends IEvent>>> getHandlers() {
        return this.handlers;
    }
}

