/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.entity;

import com.ldtteam.jvoxelizer.common.capability.ICapability;
import com.ldtteam.jvoxelizer.entity.IEntity;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.common.capability.Capability;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.core.IForgeJVoxelizerWrapper;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.facing.Facing;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.math.coordinate.block.BlockCoordinate;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.math.coordinate.entity.EntityCoordinate;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.nbt.NBTCompound;
import com.ldtteam.jvoxelizer.util.facing.IFacing;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import com.ldtteam.jvoxelizer.util.math.coordinate.entity.IEntityCoordinate;
import com.ldtteam.jvoxelizer.util.nbt.INBTCompound;
import com.ldtteam.jvoxelizer.util.ticking.data.IReadOnlyTickingDataEntry;
import com.ldtteam.jvoxelizer.util.ticking.data.ITickingDataEntry;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class Entity
implements IEntity,
IForgeJVoxelizerWrapper {
    private final net.minecraft.entity.Entity forgeEntity;

    protected Entity(@NotNull net.minecraft.entity.Entity forgeEntity) {
        this.forgeEntity = forgeEntity;
    }

    public UUID getId() {
        return this.forgeEntity.func_110124_au();
    }

    public boolean shouldEntitySpawn() {
        return this.forgeEntity.field_70156_m;
    }

    public boolean shouldEntityForceSpawn() {
        return this.forgeEntity.field_98038_p;
    }

    public int getDimension() {
        return this.forgeEntity.field_71093_bK;
    }

    public ITickingDataEntry<IEntityCoordinate> getPositionOfEntityOrigin() {
        return new ITickingDataEntry<IEntityCoordinate>(){

            public ITickingDataEntry<IEntityCoordinate> setPrevious(IEntityCoordinate previous) {
                ((Entity)Entity.this).forgeEntity.field_70169_q = previous.getX();
                ((Entity)Entity.this).forgeEntity.field_70167_r = previous.getY();
                ((Entity)Entity.this).forgeEntity.field_70166_s = previous.getZ();
                return this;
            }

            public ITickingDataEntry<IEntityCoordinate> setCurrent(IEntityCoordinate current) {
                ((Entity)Entity.this).forgeEntity.field_70165_t = current.getX();
                ((Entity)Entity.this).forgeEntity.field_70163_u = current.getY();
                ((Entity)Entity.this).forgeEntity.field_70161_v = current.getZ();
                return this;
            }

            public IEntityCoordinate getPrevious() {
                return new EntityCoordinate(((Entity)Entity.this).forgeEntity.field_70169_q, ((Entity)Entity.this).forgeEntity.field_70167_r, ((Entity)Entity.this).forgeEntity.field_70166_s);
            }

            public IEntityCoordinate getCurrent() {
                return new EntityCoordinate(((Entity)Entity.this).forgeEntity.field_70165_t, ((Entity)Entity.this).forgeEntity.field_70163_u, ((Entity)Entity.this).forgeEntity.field_70161_v);
            }
        };
    }

    public ITickingDataEntry<IBlockCoordinate> getPositionOfBlockContainingEntity() {
        return new ITickingDataEntry<IBlockCoordinate>(){

            public ITickingDataEntry<IBlockCoordinate> setPrevious(IBlockCoordinate previous) {
                ((Entity)Entity.this).forgeEntity.field_70169_q = (double)previous.getX() + (((Entity)Entity.this).forgeEntity.field_70169_q - Math.floor(((Entity)Entity.this).forgeEntity.field_70169_q));
                ((Entity)Entity.this).forgeEntity.field_70167_r = (double)previous.getY() + (((Entity)Entity.this).forgeEntity.field_70167_r - Math.floor(((Entity)Entity.this).forgeEntity.field_70167_r)) - 0.5;
                ((Entity)Entity.this).forgeEntity.field_70169_q = (double)previous.getZ() + (((Entity)Entity.this).forgeEntity.field_70166_s - Math.floor(((Entity)Entity.this).forgeEntity.field_70166_s));
                return this;
            }

            public ITickingDataEntry<IBlockCoordinate> setCurrent(IBlockCoordinate current) {
                ((Entity)Entity.this).forgeEntity.field_70165_t = (double)current.getX() + (((Entity)Entity.this).forgeEntity.field_70165_t - Math.floor(((Entity)Entity.this).forgeEntity.field_70165_t));
                ((Entity)Entity.this).forgeEntity.field_70163_u = (double)current.getY() + (((Entity)Entity.this).forgeEntity.field_70163_u - Math.floor(((Entity)Entity.this).forgeEntity.field_70163_u)) - 0.5;
                ((Entity)Entity.this).forgeEntity.field_70165_t = (double)current.getZ() + (((Entity)Entity.this).forgeEntity.field_70161_v - Math.floor(((Entity)Entity.this).forgeEntity.field_70161_v));
                return this;
            }

            public IBlockCoordinate getPrevious() {
                return new BlockCoordinate(((Entity)Entity.this).forgeEntity.field_70169_q, ((Entity)Entity.this).forgeEntity.field_70167_r + 0.5, ((Entity)Entity.this).forgeEntity.field_70166_s);
            }

            public IBlockCoordinate getCurrent() {
                return BlockCoordinate.fromForge(Entity.this.forgeEntity.func_180425_c());
            }
        };
    }

    public IReadOnlyTickingDataEntry<Float> getRotationYaw() {
        return new IReadOnlyTickingDataEntry<Float>(){

            public Float getPrevious() {
                return Float.valueOf(((Entity)Entity.this).forgeEntity.field_70126_B);
            }

            public Float getCurrent() {
                return Float.valueOf(((Entity)Entity.this).forgeEntity.field_70177_z);
            }
        };
    }

    public IReadOnlyTickingDataEntry<Float> getRotationPitch() {
        return new IReadOnlyTickingDataEntry<Float>(){

            public Float getPrevious() {
                return Float.valueOf(((Entity)Entity.this).forgeEntity.field_70127_C);
            }

            public Float getCurrent() {
                return Float.valueOf(((Entity)Entity.this).forgeEntity.field_70125_A);
            }
        };
    }

    public boolean isOnGround() {
        return this.forgeEntity.field_70122_E;
    }

    public boolean hasCollidedHorizontally() {
        return this.forgeEntity.field_70123_F;
    }

    public boolean hasCollidedVertically() {
        return this.forgeEntity.field_70124_G;
    }

    public boolean hasVelocityChanged() {
        return this.forgeEntity.field_70133_I;
    }

    public boolean isDead() {
        return this.forgeEntity.field_70128_L;
    }

    public float getWidth() {
        return this.forgeEntity.field_70130_N;
    }

    public IReadOnlyTickingDataEntry<Float> getDistanceWalkedModified() {
        return new IReadOnlyTickingDataEntry<Float>(){

            public Float getPrevious() {
                return Float.valueOf(((Entity)Entity.this).forgeEntity.field_70140_Q);
            }

            public Float getCurrent() {
                return Float.valueOf(((Entity)Entity.this).forgeEntity.field_70141_P);
            }
        };
    }

    public float getDistanceWalkedOnStepModified() {
        return this.forgeEntity.field_82151_R;
    }

    public float getFallDistance() {
        return this.forgeEntity.field_70143_R;
    }

    public IEntity setFallDistance(float fallDistance) {
        this.forgeEntity.field_70143_R = fallDistance;
        return this;
    }

    public boolean hasCapability(ICapability<?> capability, IFacing facing) {
        return this.forgeEntity.hasCapability(Capability.asForge(capability), Facing.asForge(facing));
    }

    public <T> T getCapability(ICapability<T> capability, IFacing facing) {
        return (T)capability.convertToJVoxInstanceOrNull(this.forgeEntity.getCapability(Capability.asForge(capability), Facing.asForge(facing)));
    }

    public INBTCompound write() {
        return NBTCompound.fromForge(this.forgeEntity.func_189511_e(new NBTTagCompound()));
    }

    public void read(INBTCompound data) {
        this.forgeEntity.func_70020_e(NBTCompound.asForge(data));
    }

    private net.minecraft.entity.Entity getForgeEntity() {
        return this.forgeEntity;
    }

    public static net.minecraft.entity.Entity asForge(IEntity entity) {
        if (entity instanceof net.minecraft.entity.Entity) {
            return (net.minecraft.entity.Entity)entity;
        }
        if (entity == null) {
            return null;
        }
        if (!(entity instanceof IForgeJVoxelizerWrapper)) {
            throw new IllegalArgumentException("Entity is not a wrapper");
        }
        return (net.minecraft.entity.Entity)((IForgeJVoxelizerWrapper)entity).getForgeInstance();
    }

    public static IEntity fromForge(net.minecraft.entity.Entity entity) {
        if (entity instanceof IEntity) {
            return (IEntity)entity;
        }
        return new Entity(entity);
    }

    @Override
    public <T> T getForgeInstance() {
        return (T)this.getForgeEntity();
    }
}

