/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.discovery;

import com.google.common.collect.Maps;
import com.ldtteam.jvoxelizer.discovery.IJVoxModPlugin;
import com.ldtteam.jvoxelizer.discovery.IJVoxModPluginDiscoverer;
import com.ldtteam.jvoxelizer.discovery.IJVoxModPluginDiscovererProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class JVoxASMDataTableBasedPluginDiscoverer
implements IJVoxModPluginDiscoverer,
IJVoxModPluginDiscovererProvider {
    private static JVoxASMDataTableBasedPluginDiscoverer ourInstance = new JVoxASMDataTableBasedPluginDiscoverer();
    private Boolean loaded = false;
    private final Map<String, List<IJVoxModPlugin>> plugins = Maps.newHashMap();

    public static JVoxASMDataTableBasedPluginDiscoverer getInstance() {
        return ourInstance;
    }

    private JVoxASMDataTableBasedPluginDiscoverer() {
    }

    public void discoverPlugins(Object discoveryData) {
        if (this.loaded.booleanValue()) {
            return;
        }
        this.loaded = true;
        if (!(discoveryData instanceof ASMDataTable)) {
            throw new IllegalArgumentException("Can not discover from something other then ASMDataTable");
        }
        ASMDataTable data = (ASMDataTable)discoveryData;
        Set targets = data.getAll(IJVoxModPlugin.class.getName().replace(".", "/"));
        ModClassLoader mcl = Loader.instance().getModClassLoader();
        for (ASMDataTable.ASMData target : targets) {
            try {
                Class<?> subscriptionTarget = Class.forName(target.getClassName().replace("/", "."), true, (ClassLoader)mcl);
                Object pluginObject = subscriptionTarget.newInstance();
                IJVoxModPlugin plugin = (IJVoxModPlugin)pluginObject;
                this.plugins.putIfAbsent(plugin.getTargetModId(), new ArrayList());
                this.plugins.get(plugin.getTargetModId()).add(plugin);
            }
            catch (Exception e) {
                throw new LoaderException((Throwable)e);
            }
        }
    }

    public void onPreInit(String modId) {
        ((List)this.plugins.getOrDefault(modId, new ArrayList())).forEach(IJVoxModPlugin::onPreInit);
    }

    public IJVoxModPluginDiscoverer provide() {
        return JVoxASMDataTableBasedPluginDiscoverer.getInstance();
    }
}

