/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.dimension;

import com.ldtteam.jvoxelizer.biome.IBiome;
import com.ldtteam.jvoxelizer.block.entity.IBlockEntity;
import com.ldtteam.jvoxelizer.block.state.IBlockState;
import com.ldtteam.jvoxelizer.core.logic.DummyInstanceData;
import com.ldtteam.jvoxelizer.dimension.IDimensionReader;
import com.ldtteam.jvoxelizer.dimension.IDimensionType;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.biome.Biome;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.block.entity.BlockEntity;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.block.state.BlockState;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.core.IForgeJVoxelizerWrapper;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.dimension.DimensionType;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.facing.Facing;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.math.coordinate.block.BlockCoordinate;
import com.ldtteam.jvoxelizer.util.facing.IFacing;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import net.minecraft.world.IBlockAccess;

public class DimensionReader
implements IDimensionReader<DummyInstanceData>,
IForgeJVoxelizerWrapper {
    private final IBlockAccess forgeBlockAcces;

    protected DimensionReader(IBlockAccess forgeBlockAcces) {
        this.forgeBlockAcces = forgeBlockAcces;
    }

    public IBlockEntity getBlockEntity(IBlockCoordinate pos) {
        return BlockEntity.fromForge(this.forgeBlockAcces.func_175625_s(BlockCoordinate.asForge(pos)));
    }

    public int getCombinedLight(IBlockCoordinate pos, int lightValue) {
        return this.forgeBlockAcces.func_175626_b(BlockCoordinate.asForge(pos), lightValue);
    }

    public IBlockState getBlockState(IBlockCoordinate pos) {
        return BlockState.fromForge(this.forgeBlockAcces.func_180495_p(BlockCoordinate.asForge(pos)));
    }

    public boolean isAirBlock(IBlockCoordinate pos) {
        return this.forgeBlockAcces.func_175623_d(BlockCoordinate.asForge(pos));
    }

    public IBiome getBiome(IBlockCoordinate pos) {
        return Biome.fromForge(this.forgeBlockAcces.func_180494_b(BlockCoordinate.asForge(pos)));
    }

    public int getStrongPower(IBlockCoordinate pos, IFacing direction) {
        return this.forgeBlockAcces.func_175627_a(BlockCoordinate.asForge(pos), Facing.asForge(direction));
    }

    public IDimensionType getDimensionType() {
        return DimensionType.fromForge(this.forgeBlockAcces.func_175624_G());
    }

    public boolean isSideSolid(IBlockCoordinate pos, IFacing side, boolean _default) {
        return this.forgeBlockAcces.isSideSolid(BlockCoordinate.asForge(pos), Facing.asForge(side), _default);
    }

    public DummyInstanceData getInstanceData() {
        return new DummyInstanceData();
    }

    private IBlockAccess getForgeBlockAcces() {
        return this.forgeBlockAcces;
    }

    public static IBlockAccess asForge(IDimensionReader<?> dimensionReader) {
        if (dimensionReader instanceof IBlockAccess) {
            return (IBlockAccess)dimensionReader;
        }
        if (dimensionReader == null) {
            return null;
        }
        if (!(dimensionReader instanceof IForgeJVoxelizerWrapper)) {
            throw new IllegalArgumentException("DimensionReader is not a wrapper");
        }
        return (IBlockAccess)((IForgeJVoxelizerWrapper)dimensionReader).getForgeInstance();
    }

    public static IDimensionReader<?> fromForge(IBlockAccess blockAccess) {
        if (blockAccess instanceof IDimensionReader) {
            return (IDimensionReader)blockAccess;
        }
        return new DimensionReader(blockAccess);
    }

    @Override
    public <T> T getForgeInstance() {
        return (T)this.getForgeBlockAcces();
    }
}

