/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.dimension;

import com.ldtteam.jvoxelizer.core.logic.DummyInstanceData;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.entity.IEntity;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.core.IForgeJVoxelizerWrapper;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.dimension.DimensionReader;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.entity.Entity;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Dimension
extends DimensionReader
implements IDimension<DummyInstanceData> {
    private final World forgeWorld;

    private Dimension(World world) {
        super((IBlockAccess)world);
        this.forgeWorld = world;
    }

    public int getId() {
        return this.forgeWorld.field_73011_w.getDimension();
    }

    public List<IEntity> getLoadedEntities() {
        return this.forgeWorld.func_72910_y().stream().map(Entity::fromForge).collect(Collectors.toList());
    }

    private World getForgeWorld() {
        return this.forgeWorld;
    }

    public static World asForge(IDimension<?> dimension) {
        if (dimension instanceof World) {
            return (World)dimension;
        }
        if (dimension == null) {
            return null;
        }
        if (!(dimension instanceof IForgeJVoxelizerWrapper)) {
            throw new IllegalArgumentException("Dimension is not a wrapper");
        }
        return (World)((IForgeJVoxelizerWrapper)dimension).getForgeInstance();
    }

    public static IDimension<?> fromForge(World world) {
        if (world instanceof IDimension) {
            return (IDimension)world;
        }
        return new Dimension(world);
    }
}

