/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12.block.entity;

import com.ldtteam.jvoxelizer.block.entity.IBlockEntity;
import com.ldtteam.jvoxelizer.common.capability.ICapability;
import com.ldtteam.jvoxelizer.dimension.IDimension;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.common.capability.Capability;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.core.IForgeJVoxelizerWrapper;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.dimension.Dimension;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.facing.Facing;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.math.coordinate.block.BlockCoordinate;
import com.ldtteam.jvoxelizer.util.facing.IFacing;
import com.ldtteam.jvoxelizer.util.math.coordinate.block.IBlockCoordinate;
import net.minecraft.tileentity.TileEntity;

public class BlockEntity
implements IBlockEntity,
IForgeJVoxelizerWrapper {
    private final TileEntity forgeTileEntity;

    private BlockEntity(TileEntity forgeTileEntity) {
        this.forgeTileEntity = forgeTileEntity;
    }

    public IDimension getDimension() {
        return Dimension.fromForge(this.forgeTileEntity.func_145831_w());
    }

    public IBlockCoordinate getPosition() {
        return BlockCoordinate.fromForge(this.forgeTileEntity.func_174877_v());
    }

    public boolean hasCapability(ICapability<?> capability, IFacing facing) {
        return this.forgeTileEntity.hasCapability(Capability.asForge(capability), Facing.asForge(facing));
    }

    public <T> T getCapability(ICapability<T> capability, IFacing facing) {
        return (T)capability.convertToJVoxInstanceOrNull(this.forgeTileEntity.getCapability(Capability.asForge(capability), Facing.asForge(facing)));
    }

    public TileEntity getForgeTileEntity() {
        return this.forgeTileEntity;
    }

    public static TileEntity asForge(IBlockEntity blockEntity) {
        if (blockEntity instanceof TileEntity) {
            return (TileEntity)blockEntity;
        }
        if (blockEntity == null) {
            return null;
        }
        if (!(blockEntity instanceof IForgeJVoxelizerWrapper)) {
            throw new IllegalArgumentException("BlockEntity is not a wrapper");
        }
        return (TileEntity)((IForgeJVoxelizerWrapper)blockEntity).getForgeInstance();
    }

    public static IBlockEntity fromForge(TileEntity tileEntity) {
        if (tileEntity instanceof IBlockEntity) {
            return (IBlockEntity)tileEntity;
        }
        return new BlockEntity(tileEntity);
    }

    @Override
    public <T> T getForgeInstance() {
        return (T)this.getForgeTileEntity();
    }
}

