/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.jvoxelizer.launcher.forge_1_12;

import com.ldtteam.jvoxelizer.discovery.IJVoxModPluginDiscoverer;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.core.IForgeJVoxelizerSetupProxy;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.proxy.ClientProxy;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.proxy.CommonProxy;
import com.ldtteam.jvoxelizer.launcher.forge_1_12.util.distribution.executor.DistributionExecutor;
import java.util.function.Supplier;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;

public abstract class AbstractForgeMod {
    private Logger logger;
    private String modId;
    private IForgeJVoxelizerSetupProxy setupProxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.modId = event.getModMetadata().modId;
        Supplier proxySupplier = DistributionExecutor.getInstance().runOn(() -> ClientProxy::new, () -> CommonProxy::new);
        this.setupProxy = (IForgeJVoxelizerSetupProxy)proxySupplier.get();
        this.logger = event.getModLog();
        this.logger.info("Initializing JVoxelizer.");
        this.registerProviders();
        IJVoxModPluginDiscoverer.get().discoverPlugins((Object)event.getAsmData());
    }

    private void registerProviders() {
        this.registerInternalProviders();
        this.registerModProviders();
    }

    private void registerInternalProviders() {
        this.setupProxy.onPreInit();
    }

    private void registerModProviders() {
        this.getModSetupProxy().onPreInit();
    }

    protected abstract IForgeJVoxelizerSetupProxy getModSetupProxy();

    protected void preInitializePlugins() {
        IJVoxModPluginDiscoverer.get().onPreInit(this.modId);
    }
}

