/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.utils.controlconstruction.element.core;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.binding.property.PropertyCreationHelper;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.builder.core.builder.IBlockOutUIElementConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.event.IEventHandler;
import com.ldtteam.blockout.factory.IUIElementFactory;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.IUIElementDataBuilder;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSimpleUIElement
implements IUIElement {
    @NotNull
    private final UUID uniqueIdentifier = UUID.randomUUID();
    @NotNull
    private final String type;
    @NotNull
    private final String id;
    @NotNull
    private IDependencyObject<IIdentifier> style;
    @NotNull
    private IUIElementHost parent;
    @NotNull
    public IDependencyObject<EnumSet<Alignment>> alignments;
    @NotNull
    public IDependencyObject<Dock> dock;
    @NotNull
    public IDependencyObject<AxisDistance> margin;
    @NotNull
    public IDependencyObject<Vector2d> elementSize;
    @NotNull
    private BoundingBox localBoundingBox;
    @NotNull
    private BoundingBox absoluteBoundingBox;
    @NotNull
    public IDependencyObject<Object> dataContext;
    @NotNull
    public IDependencyObject<Boolean> visible;
    @NotNull
    public IDependencyObject<Boolean> enabled;

    public AbstractSimpleUIElement(@NotNull String type, @NotNull IDependencyObject<IIdentifier> style, @NotNull String id, @NotNull IUIElementHost parent, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled) {
        this.type = type;
        this.style = style;
        this.id = id;
        this.parent = parent;
        this.alignments = alignments;
        this.dock = dock;
        this.margin = margin;
        this.elementSize = elementSize;
        this.dataContext = dataContext;
        this.visible = visible;
        this.enabled = enabled;
    }

    public UUID getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public IIdentifier getStyleId() {
        return (IIdentifier)this.style.get((IDependencyReceiver)this);
    }

    public void update(@NotNull IUpdateManager updateManager) {
        if (this.updateBoundingBoxes()) {
            updateManager.markDirty();
        }
        if (this.dataContext.hasChanged((IDependencyReceiver)this.parent)) {
            updateManager.markDirty();
        }
        if (this.alignments.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.style.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.dock.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.margin.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.enabled.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.visible.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
        if (this.elementSize.hasChanged((IDependencyReceiver)this)) {
            updateManager.markDirty();
        }
    }

    @Nullable
    public Object getDataContext() {
        if (this.dataContext.requiresDataContext()) {
            return this.dataContext.get(this.getParent().getDataContext());
        }
        return this.dataContext.get((IDependencyReceiver)this);
    }

    public void setDataContext(@Nullable Object dataContext) {
        if (this.dataContext.requiresDataContext()) {
            this.dataContext.set(this.getParent().getDataContext(), dataContext);
        }
        this.dataContext.set((IDependencyReceiver)this, dataContext);
    }

    public EnumSet<Alignment> getAlignment() {
        return (EnumSet)this.alignments.get((IDependencyReceiver)this);
    }

    public void setAlignment(@NotNull EnumSet<Alignment> alignment) {
        this.alignments.set((IDependencyReceiver)this, alignment);
    }

    public Dock getDock() {
        return (Dock)this.dock.get((IDependencyReceiver)this);
    }

    public void setDock(@NotNull Dock dock) {
        this.dock.set((IDependencyReceiver)this, (Object)dock);
    }

    @NotNull
    public BoundingBox getLocalBoundingBox() {
        return this.localBoundingBox;
    }

    @NotNull
    public BoundingBox getAbsoluteBoundingBox() {
        return this.absoluteBoundingBox;
    }

    public boolean isVisible() {
        return (Boolean)this.visible.get((IDependencyReceiver)this) != false && (this == this.getParent() || this.getParent().isVisible());
    }

    public void setVisible(boolean visible) {
        this.visible.set((IDependencyReceiver)this, (Object)visible);
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get((IDependencyReceiver)this) != false && this.isVisible() && (this == this.getParent() || this.getParent().isEnabled());
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set((IDependencyReceiver)this, (Object)enabled);
    }

    @NotNull
    public IUIElementHost getParent() {
        return this.parent;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public AxisDistance getMargin() {
        return (AxisDistance)this.margin.get((IDependencyReceiver)this);
    }

    public void setMargin(@NotNull AxisDistance margin) {
        this.margin.set((IDependencyReceiver)this, (Object)margin);
    }

    public Vector2d getElementSize() {
        return (Vector2d)this.elementSize.get((IDependencyReceiver)this);
    }

    public void setElementSize(@NotNull Vector2d elementSize) {
        this.elementSize.set((IDependencyReceiver)this, (Object)elementSize);
    }

    public void setParent(@NotNull IUIElementHost parent) {
        this.parent = parent;
    }

    private boolean updateBoundingBoxes() {
        boolean updated = false;
        if (this.updateLocalBoundingBox()) {
            updated = true;
        }
        this.updateAbsoluteBoundingBox();
        return updated;
    }

    private boolean updateLocalBoundingBox() {
        BoundingBox currentBoundingBox = this.localBoundingBox;
        Vector2d parentSize = this.getParent() != this ? this.getParent().getLocalInternalBoundingBox().getSize() : new Vector2d(Double.MAX_VALUE, Double.MAX_VALUE);
        Optional<Double> marginLeft = this.getMargin().getLeft();
        Optional<Double> marginTop = this.getMargin().getTop();
        Optional marginRight = this.getMargin().getRight();
        Optional marginBottom = this.getMargin().getBottom();
        double width = this.getElementSize().getX();
        double height = this.getElementSize().getY();
        if (Alignment.LEFT.isActive((IUIElement)this) && Alignment.RIGHT.isActive((IUIElement)this)) {
            if (!marginLeft.isPresent() && !marginRight.isPresent()) {
                marginLeft = Optional.of((parentSize.getX() - width) / 2.0);
            } else if (!marginLeft.isPresent()) {
                marginLeft = Optional.of(0.0);
                width = parentSize.getX() - marginRight.orElse(0.0);
            } else {
                width = !marginRight.isPresent() ? parentSize.getX() - marginLeft.orElse(0.0) : parentSize.getX() - marginLeft.get() - (Double)marginRight.get();
            }
        } else if (Alignment.RIGHT.isActive((IUIElement)this)) {
            marginLeft = Optional.of(parentSize.getX() - width - marginRight.orElse(0.0));
        }
        if (Alignment.TOP.isActive((IUIElement)this) && Alignment.BOTTOM.isActive((IUIElement)this)) {
            if (!marginTop.isPresent() && !marginBottom.isPresent()) {
                marginTop = Optional.of((parentSize.getY() - height) / 2.0);
            } else if (!marginTop.isPresent()) {
                marginTop = Optional.of(0.0);
                height = parentSize.getY() - marginBottom.orElse(0.0);
            } else {
                height = !marginBottom.isPresent() ? parentSize.getY() - marginTop.orElse(0.0) : parentSize.getY() - marginTop.get() - (Double)marginBottom.get();
            }
        } else if (Alignment.BOTTOM.isActive((IUIElement)this)) {
            marginTop = Optional.of(parentSize.getY() - height - marginBottom.orElse(0.0));
        }
        Vector2d origin = new Vector2d(marginLeft.orElse(0.0).doubleValue(), marginTop.orElse(0.0).doubleValue());
        Vector2d size = new Vector2d(width, height).nullifyNegatives();
        this.localBoundingBox = new BoundingBox(origin, size);
        this.localBoundingBox = this.getDock().apply((IUIElement)this, this.localBoundingBox);
        return currentBoundingBox == null || !currentBoundingBox.equals((Object)this.localBoundingBox);
    }

    private void updateAbsoluteBoundingBox() {
        if (this.getParent() == this) {
            this.absoluteBoundingBox = this.getLocalBoundingBox();
            return;
        }
        BoundingBox parentAbsoluteBindingBox = this.getParent().getAbsoluteInternalBoundingBox();
        this.absoluteBoundingBox = new BoundingBox(parentAbsoluteBindingBox.getLocalOrigin().move(this.getLocalBoundingBox().getLocalOrigin()), this.getLocalBoundingBox().getSize());
    }

    public static abstract class AbstractSimpleUIElementFactory<U extends IUIElement>
    implements IUIElementFactory<U> {
        private final Class<U> clz;
        private final String type;
        private final ISimpleUIElementConstructor<U> constructor;
        private final ISimpleUIElementWriter<U> writer;

        protected AbstractSimpleUIElementFactory(Class<U> clz, String type, ISimpleUIElementConstructor<U> constructor, ISimpleUIElementWriter<U> writer) {
            this.clz = clz;
            this.type = type;
            this.constructor = constructor;
            this.writer = writer;
        }

        @NotNull
        public final Class<U> getProducedElementClass() {
            return this.clz;
        }

        @NotNull
        public final String getTypeName() {
            return this.type;
        }

        @NotNull
        public final U readFromElementData(@NotNull IUIElementData<?> elementData, @NotNull IBindingEngine engine) {
            IDependencyObject style = elementData.getMetaData().getParent().map(parent -> elementData.getFromRawDataWithProperty("style", engine, PropertyCreationHelper.createFromOptional(o -> parent.getStyleId(), null, (boolean)true), (Object)IIdentifier.create((String)Constants.Styles.CONST_DEFAULT), IIdentifier.class, new Object[0])).orElse(elementData.getFromRawDataWithDefault("style", engine, (Object)IIdentifier.create((String)Constants.Styles.CONST_DEFAULT), IIdentifier.class, new Object[0]));
            IDependencyObject alignments = elementData.getFromRawDataWithDefault("alignment", engine, EnumSet.of(Alignment.LEFT, Alignment.TOP), Constants.ConverterTypes.ALIGNMENT_ENUMSET_TYPE, new Object[0]);
            IDependencyObject dock = elementData.getFromRawDataWithDefault("dock", engine, (Object)Dock.NONE, Dock.class, new Object[]{Dock.class});
            IDependencyObject margin = elementData.getFromRawDataWithDefault("margin", engine, (Object)AxisDistance.DEFAULT, AxisDistance.class, new Object[0]);
            IDependencyObject elementSize = elementData.getFromRawDataWithDefault("size", engine, (Object)Vector2d.DEFAULT, Vector2d.class, new Object[0]);
            IDependencyObject dataContext = elementData.getMetaData().getParent().map(parent -> elementData.getFromRawDataWithProperty("context", engine, PropertyCreationHelper.createFromNonOptional(c -> parent.getDataContext(), (c, o) -> parent.setDataContext(o), (boolean)true), new Object(), Object.class, new Object[0])).orElse(elementData.getFromRawDataWithDefault("context", engine, new Object(), Object.class, new Object[0]));
            IDependencyObject visible = elementData.getFromRawDataWithDefault("visible", engine, (Object)true, Boolean.class, new Object[0]);
            IDependencyObject enabled = elementData.getFromRawDataWithDefault("enabled", engine, (Object)true, Boolean.class, new Object[0]);
            U element = this.constructor.constructUsing(elementData, engine, elementData.getMetaData().getId(), elementData.getMetaData().getParent().orElse(null), (IDependencyObject<IIdentifier>)style, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled);
            return element;
        }

        public final void writeToElementData(@NotNull U element, @NotNull IUIElementDataBuilder<?> builder) {
            builder.addComponent("alignment", (Object)element.getAlignment(), Constants.ConverterTypes.ALIGNMENT_ENUMSET_TYPE).addComponent("dock", (Object)element.getDock(), Dock.class).addComponent("margin", (Object)element.getMargin(), AxisDistance.class).addComponent("size", (Object)element.getElementSize(), Vector2d.class).addComponent("visible", (Object)element.isVisible(), Boolean.class).addComponent("enabled", (Object)element.isEnabled(), Boolean.class);
            this.writer.write(element, builder);
        }

        @FunctionalInterface
        protected static interface ISimpleUIElementWriter<U extends IUIElement> {
            public void write(@NotNull U var1, @NotNull IUIElementDataBuilder<?> var2);
        }

        @FunctionalInterface
        protected static interface ISimpleUIElementConstructor<U extends IUIElement> {
            public U constructUsing(@NotNull IUIElementData<?> var1, @NotNull IBindingEngine var2, @NotNull String var3, @Nullable IUIElementHost var4, @NotNull IDependencyObject<IIdentifier> var5, @NotNull IDependencyObject<EnumSet<Alignment>> var6, @NotNull IDependencyObject<Dock> var7, @NotNull IDependencyObject<AxisDistance> var8, @NotNull IDependencyObject<Vector2d> var9, @NotNull IDependencyObject<Object> var10, @NotNull IDependencyObject<Boolean> var11, @NotNull IDependencyObject<Boolean> var12);
        }
    }

    public static abstract class SimpleControlConstructionDataBuilder<B extends SimpleControlConstructionDataBuilder<B, S>, S extends AbstractSimpleUIElement>
    implements IBlockOutUIElementConstructionDataBuilder<B, S> {
        private final String controlId;
        private final IBlockOutGuiConstructionDataBuilder data;
        private final Class<S> controlClass;

        protected SimpleControlConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data, Class<S> controlClass) {
            this.controlId = controlId;
            this.data = data;
            this.controlClass = controlClass;
        }

        @NotNull
        public B withDependentAllignments(@NotNull IDependencyObject<EnumSet<Alignment>> alignments) {
            return (B)this.withDependency("alignments", (IDependencyObject)alignments);
        }

        @NotNull
        public B withDependency(@NotNull String fieldName, @NotNull IDependencyObject<?> dependency) {
            this.data.withDependency(this.controlId, fieldName, dependency);
            return (B)this;
        }

        @NotNull
        public <A> B withEventHandler(@NotNull String eventName, @NotNull Class<A> argumentTypeClass, @NotNull IEventHandler<S, A> eventHandler) {
            this.data.withEventHandler(this.controlId, eventName, this.controlClass, argumentTypeClass, eventHandler);
            return (B)this;
        }

        @NotNull
        public B withDependentDock(@NotNull IDependencyObject<Dock> dock) {
            return (B)this.withDependency("dock", (IDependencyObject)dock);
        }

        @NotNull
        public B withDependentMargin(@NotNull IDependencyObject<AxisDistance> margin) {
            return (B)this.withDependency("margin", (IDependencyObject)margin);
        }

        @NotNull
        public B withDependentSize(@NotNull IDependencyObject<Vector2d> elementSize) {
            return (B)this.withDependency("elementSize", (IDependencyObject)elementSize);
        }

        @NotNull
        public B withDependentDataContext(@NotNull IDependencyObject<Object> dataContext) {
            return (B)this.withDependency("dataContext", (IDependencyObject)dataContext);
        }

        @NotNull
        public B withDependentVisibility(@NotNull IDependencyObject<Boolean> visible) {
            return (B)this.withDependency("visible", (IDependencyObject)visible);
        }

        @NotNull
        public B withDependentEnablement(@NotNull IDependencyObject<Boolean> enabled) {
            return (B)this.withDependency("enabled", (IDependencyObject)enabled);
        }

        @NotNull
        public B withAllignments(@NotNull EnumSet<Alignment> alignments) {
            return (B)this.withDependency("alignments", DependencyObjectHelper.createFromValue(alignments));
        }

        @NotNull
        public B withDock(@NotNull Dock dock) {
            return (B)this.withDependency("dock", DependencyObjectHelper.createFromValue((Object)dock));
        }

        @NotNull
        public B withMargin(@NotNull AxisDistance margin) {
            return (B)this.withDependency("margin", DependencyObjectHelper.createFromValue((Object)margin));
        }

        @NotNull
        public B withSize(@NotNull Vector2d elementSize) {
            return (B)this.withDependency("elementSize", DependencyObjectHelper.createFromValue((Object)elementSize));
        }

        @NotNull
        public B withDataContext(@NotNull Object dataContext) {
            return (B)this.withDependency("dataContext", DependencyObjectHelper.createFromValue((Object)dataContext));
        }

        @NotNull
        public B withVisibility(@NotNull Boolean visible) {
            return (B)this.withDependency("visible", DependencyObjectHelper.createFromValue((Object)visible));
        }

        @NotNull
        public B withEnablement(@NotNull Boolean enabled) {
            return (B)this.withDependency("enabled", DependencyObjectHelper.createFromValue((Object)enabled));
        }
    }
}

