/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.utils.controlconstruction.element.core;

import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractChildrenContainingUIElement;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFilteringChildrenContainingUIElement
extends AbstractChildrenContainingUIElement {
    public AbstractFilteringChildrenContainingUIElement(@NotNull String type, @NotNull IDependencyObject<IIdentifier> style, @NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<AxisDistance> padding, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled) {
        super(type, style, id, parent, alignments, dock, margin, elementSize, padding, dataContext, visible, enabled);
    }

    public abstract Predicate<IUIElement> IsValidChildPredicate();

    @Override
    public IUIElement put(String key, IUIElement value) {
        this.IsValidChild(value);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends IUIElement> m) {
        for (IUIElement iUIElement : m.values()) {
            this.IsValidChild(iUIElement);
        }
        super.putAll(m);
    }

    @Override
    public IUIElement putIfAbsent(String key, IUIElement value) {
        if (!this.containsKey(key)) {
            this.IsValidChild(value);
        }
        return super.putIfAbsent(key, value);
    }

    @Override
    public boolean replace(String key, IUIElement oldValue, IUIElement newValue) {
        if (this.containsKey(key) && Objects.equals(this.get(key), oldValue)) {
            this.IsValidChild(newValue);
        }
        return super.replace(key, oldValue, newValue);
    }

    @Override
    public IUIElement replace(String key, IUIElement value) {
        if (this.containsKey(key)) {
            this.IsValidChild(value);
        }
        return super.replace(key, value);
    }

    @Override
    public IUIElement computeIfAbsent(String key, Function<? super String, ? extends IUIElement> mappingFunction) {
        if (this.get(key) == null) {
            IUIElement target = mappingFunction.apply(key);
            this.put(key, target);
        }
        return (IUIElement)this.get(key);
    }

    @Override
    public IUIElement computeIfPresent(String key, BiFunction<? super String, ? super IUIElement, ? extends IUIElement> remappingFunction) {
        if (this.get(key) != null) {
            IUIElement current = (IUIElement)this.get(key);
            IUIElement target = remappingFunction.apply(key, (IUIElement)current);
            this.put(key, target);
        }
        return (IUIElement)this.get(key);
    }

    @Override
    public IUIElement compute(String key, BiFunction<? super String, ? super IUIElement, ? extends IUIElement> remappingFunction) {
        IUIElement current = (IUIElement)this.get(key);
        IUIElement target = remappingFunction.apply(key, (IUIElement)current);
        this.put(key, target);
        return (IUIElement)this.get(key);
    }

    @Override
    public IUIElement merge(String key, IUIElement value, BiFunction<? super IUIElement, ? super IUIElement, ? extends IUIElement> remappingFunction) {
        IUIElement oldValue = (IUIElement)this.get(key);
        IUIElement newValue = oldValue == null ? value : remappingFunction.apply((IUIElement)oldValue, (IUIElement)value);
        this.put(key, newValue);
        return (IUIElement)this.get(key);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super IUIElement, ? extends IUIElement> function) {
        try {
            for (Map.Entry entry : this.entrySet()) {
                IUIElement newElement = function.apply((String)entry.getKey(), (IUIElement)entry.getValue());
                this.IsValidChild(newElement);
                entry.setValue(newElement);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to replace some elements.", ex);
        }
    }

    private void IsValidChild(IUIElement element) {
        if (!this.IsValidChildPredicate().test(element)) {
            throw new IllegalArgumentException(String.format("An Element of type: %s cannot contain elements of type: %s", this.getType(), element.getType()));
        }
        if (element instanceof IUIElementHost) {
            IUIElementHost iuiElementHost = (IUIElementHost)element;
            iuiElementHost.values().forEach(this::IsValidChild);
        }
    }
}

