/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.utils.controlconstruction.element.core;

import com.ldtteam.blockout.binding.dependency.DependencyObjectHelper;
import com.ldtteam.blockout.binding.dependency.IDependencyObject;
import com.ldtteam.blockout.binding.dependency.IDependencyReceiver;
import com.ldtteam.blockout.builder.core.builder.IBlockOutGuiConstructionDataBuilder;
import com.ldtteam.blockout.builder.core.builder.IBlockOutUIElementConstructionDataBuilder;
import com.ldtteam.blockout.element.IUIElement;
import com.ldtteam.blockout.element.IUIElementHost;
import com.ldtteam.blockout.element.values.Alignment;
import com.ldtteam.blockout.element.values.AxisDistance;
import com.ldtteam.blockout.element.values.Dock;
import com.ldtteam.blockout.event.IEventHandler;
import com.ldtteam.blockout.loader.binding.core.IBindingEngine;
import com.ldtteam.blockout.loader.core.IUIElementData;
import com.ldtteam.blockout.loader.core.IUIElementDataBuilder;
import com.ldtteam.blockout.management.update.IUpdateManager;
import com.ldtteam.blockout.proxy.ProxyHolder;
import com.ldtteam.blockout.util.Constants;
import com.ldtteam.blockout.util.math.BoundingBox;
import com.ldtteam.blockout.util.math.Vector2d;
import com.ldtteam.blockout.utils.controlconstruction.element.core.AbstractSimpleUIElement;
import com.ldtteam.jvoxelizer.util.identifier.IIdentifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChildrenContainingUIElement
extends LinkedHashMap<String, IUIElement>
implements IUIElementHost {
    @NotNull
    private final UUID uniqueIdentifier = UUID.randomUUID();
    @NotNull
    protected final String type;
    @NotNull
    protected final String id;
    @NotNull
    public IDependencyObject<IIdentifier> style;
    @NotNull
    protected IUIElementHost parent;
    @NotNull
    public IDependencyObject<EnumSet<Alignment>> alignments = DependencyObjectHelper.createFromValue(EnumSet.of(Alignment.NONE));
    @NotNull
    public IDependencyObject<Dock> dock = DependencyObjectHelper.createFromValue((Object)Dock.NONE);
    @NotNull
    public IDependencyObject<AxisDistance> margin = DependencyObjectHelper.createFromValue((Object)new AxisDistance());
    @NotNull
    public IDependencyObject<Vector2d> elementSize = DependencyObjectHelper.createFromValue((Object)new Vector2d());
    @NotNull
    public IDependencyObject<AxisDistance> padding = DependencyObjectHelper.createFromValue((Object)new AxisDistance());
    @NotNull
    protected BoundingBox localBoundingBox;
    @NotNull
    protected BoundingBox absoluteBoundingBox;
    @NotNull
    protected BoundingBox localInternalBoundingBox;
    @NotNull
    protected BoundingBox absoluteInternalBoundingBox;
    @NotNull
    public IDependencyObject<Object> dataContext = DependencyObjectHelper.createFromValue((Object)new Object());
    @NotNull
    public IDependencyObject<Boolean> visible = DependencyObjectHelper.createFromValue((Object)true);
    @NotNull
    public IDependencyObject<Boolean> enabled = DependencyObjectHelper.createFromValue((Object)true);

    public AbstractChildrenContainingUIElement(@NotNull String type, @NotNull IDependencyObject<IIdentifier> style, @NotNull String id, @Nullable IUIElementHost parent, @NotNull IDependencyObject<EnumSet<Alignment>> alignments, @NotNull IDependencyObject<Dock> dock, @NotNull IDependencyObject<AxisDistance> margin, @NotNull IDependencyObject<Vector2d> elementSize, @NotNull IDependencyObject<AxisDistance> padding, @NotNull IDependencyObject<Object> dataContext, @NotNull IDependencyObject<Boolean> visible, @NotNull IDependencyObject<Boolean> enabled) {
        this.type = type;
        this.style = style;
        this.id = id;
        this.parent = parent;
        this.alignments = alignments;
        this.dock = dock;
        this.margin = margin;
        this.elementSize = elementSize;
        this.padding = padding;
        this.dataContext = dataContext;
        this.visible = visible;
        this.enabled = enabled;
    }

    public AbstractChildrenContainingUIElement(@NotNull String type, @NotNull IDependencyObject<IIdentifier> style, @NotNull String id, @Nullable IUIElementHost parent) {
        this.type = type;
        this.style = style;
        this.id = id;
        this.parent = parent;
    }

    public UUID getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public IIdentifier getStyleId() {
        return (IIdentifier)this.style.get((IDependencyReceiver)this);
    }

    public void update(@NotNull IUpdateManager updateManager) {
        this.getParent().getUiManager().getProfiler().startSection("Update: " + this.getId());
        if (this.updateBoundingBoxes()) {
            updateManager.markDirty();
        }
        if (this.dataContext.hasChanged(this.parent.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.alignments.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.style.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.dock.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.margin.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.enabled.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.visible.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.elementSize.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        if (this.padding.hasChanged(this.getDataContext())) {
            updateManager.markDirty();
        }
        this.getParent().getUiManager().getProfiler().endSection();
    }

    @Nullable
    public Object getDataContext() {
        if (this.getParent() == this) {
            return new Object();
        }
        if (this.dataContext.requiresDataContext()) {
            return this.dataContext.get(this.getParent().getDataContext());
        }
        return this.dataContext.get((IDependencyReceiver)this);
    }

    public void setDataContext(@Nullable Object dataContext) {
        if (this.dataContext.requiresDataContext()) {
            this.dataContext.set(this.getParent().getDataContext(), dataContext);
        }
        this.dataContext.set((IDependencyReceiver)this, dataContext);
    }

    public EnumSet<Alignment> getAlignment() {
        return (EnumSet)this.alignments.get((IDependencyReceiver)this);
    }

    public void setAlignment(@NotNull EnumSet<Alignment> alignment) {
        this.alignments.set((IDependencyReceiver)this, alignment);
    }

    public Dock getDock() {
        return (Dock)this.dock.get((IDependencyReceiver)this);
    }

    public void setDock(@NotNull Dock dock) {
        this.dock.set((IDependencyReceiver)this, (Object)dock);
    }

    @Nullable
    public BoundingBox getLocalBoundingBox() {
        return this.localBoundingBox;
    }

    @NotNull
    public BoundingBox getAbsoluteBoundingBox() {
        return this.absoluteBoundingBox;
    }

    public boolean isVisible() {
        return (Boolean)this.visible.get((IDependencyReceiver)this) != false && (this.getParent() == this || this.getParent().isVisible());
    }

    public void setVisible(boolean visible) {
        this.visible.set((IDependencyReceiver)this, (Object)visible);
    }

    public boolean isEnabled() {
        return (Boolean)this.enabled.get((IDependencyReceiver)this) != false && this.isVisible() && (this.getParent() == this || this.getParent().isEnabled());
    }

    public void setEnabled(boolean enabled) {
        this.enabled.set((IDependencyReceiver)this, (Object)enabled);
    }

    @NotNull
    public IUIElementHost getParent() {
        return this.parent;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public AxisDistance getMargin() {
        return (AxisDistance)this.margin.get((IDependencyReceiver)this);
    }

    public void setMargin(@NotNull AxisDistance margin) {
        this.margin.set((IDependencyReceiver)this, (Object)margin);
    }

    public Vector2d getElementSize() {
        return (Vector2d)this.elementSize.get((IDependencyReceiver)this);
    }

    public void setElementSize(@NotNull Vector2d elementSize) {
        this.elementSize.set((IDependencyReceiver)this, (Object)elementSize);
    }

    public void setParent(@NotNull IUIElementHost parent) {
        this.parent = parent;
    }

    private boolean updateBoundingBoxes() {
        boolean updated = false;
        if (this.updateLocalBoundingBox()) {
            updated = true;
        }
        this.updateAbsoluteBoundingBox();
        this.updateLocalInternalBoundingBox();
        this.updateAbsoluteInternalBoundingBox();
        return updated;
    }

    private boolean updateLocalBoundingBox() {
        this.getParent().getUiManager().getProfiler().startSection("Size calculation of: " + this.getId());
        BoundingBox currentBoundingBox = this.localBoundingBox;
        Vector2d parentSize = this.getParent() != this ? this.getParent().getLocalInternalBoundingBox().getSize() : new Vector2d(Double.MAX_VALUE, Double.MAX_VALUE);
        Optional<Double> marginLeft = this.getMargin().getLeft();
        Optional<Double> marginTop = this.getMargin().getTop();
        Optional marginRight = this.getMargin().getRight();
        Optional marginBottom = this.getMargin().getBottom();
        double width = this.getElementSize().getX();
        double height = this.getElementSize().getY();
        if (Alignment.LEFT.isActive((IUIElement)this) && Alignment.RIGHT.isActive((IUIElement)this)) {
            if (!marginLeft.isPresent() && !marginRight.isPresent()) {
                marginLeft = Optional.of((parentSize.getX() - width) / 2.0);
            } else if (!marginLeft.isPresent()) {
                marginLeft = Optional.of(0.0);
                width = parentSize.getX() - marginRight.orElse(0.0);
            } else {
                width = !marginRight.isPresent() ? parentSize.getX() - marginLeft.orElse(0.0) : parentSize.getX() - marginLeft.get() - (Double)marginRight.get();
            }
        } else if (Alignment.RIGHT.isActive((IUIElement)this)) {
            marginLeft = Optional.of(parentSize.getX() - width - marginRight.orElse(0.0));
        } else if (!Alignment.LEFT.isActive((IUIElement)this) && !Alignment.RIGHT.isActive((IUIElement)this) && width == 0.0) {
            width = this.getMinimalContentSize().getX();
        }
        if (Alignment.TOP.isActive((IUIElement)this) && Alignment.BOTTOM.isActive((IUIElement)this)) {
            if (!marginTop.isPresent() && !marginBottom.isPresent()) {
                marginTop = Optional.of((parentSize.getY() - height) / 2.0);
            } else if (!marginTop.isPresent()) {
                marginTop = Optional.of(0.0);
                height = parentSize.getY() - marginBottom.orElse(0.0);
            } else {
                height = !marginBottom.isPresent() ? parentSize.getY() - marginTop.orElse(0.0) : parentSize.getY() - marginTop.get() - (Double)marginBottom.get();
            }
        } else if (Alignment.BOTTOM.isActive((IUIElement)this)) {
            marginTop = Optional.of(parentSize.getY() - height - marginBottom.orElse(0.0));
        } else if (!Alignment.TOP.isActive((IUIElement)this) && !Alignment.BOTTOM.isActive((IUIElement)this) && height == 0.0) {
            height = this.getMinimalContentSize().getY();
        }
        Vector2d origin = new Vector2d(marginLeft.orElse(0.0).doubleValue(), marginTop.orElse(0.0).doubleValue());
        Vector2d size = new Vector2d(width, height).nullifyNegatives();
        this.localBoundingBox = new BoundingBox(origin, size);
        this.localBoundingBox = this.getDock().apply((IUIElement)this, this.localBoundingBox);
        this.getParent().getUiManager().getProfiler().endSection();
        return currentBoundingBox == null || !currentBoundingBox.equals((Object)this.localBoundingBox);
    }

    private void updateAbsoluteBoundingBox() {
        if (this.getParent() == this) {
            this.absoluteBoundingBox = this.getLocalBoundingBox();
            return;
        }
        BoundingBox parentAbsoluteBindingBox = this.getParent().getAbsoluteInternalBoundingBox();
        this.absoluteBoundingBox = new BoundingBox(parentAbsoluteBindingBox.getLocalOrigin().move(this.getLocalBoundingBox().getLocalOrigin()), this.getLocalBoundingBox().getSize());
    }

    private void updateLocalInternalBoundingBox() {
        Vector2d origin = this.localBoundingBox.getLocalOrigin().move(this.getPadding().getLeft().orElse(0.0).doubleValue(), this.getPadding().getTop().orElse(0.0).doubleValue());
        Vector2d size = this.localBoundingBox.getSize().move(-1.0 * (this.getPadding().getLeft().orElse(0.0) + this.getPadding().getRight().orElse(0.0)), -1.0 * (this.getPadding().getTop().orElse(0.0) + this.getPadding().getBottom().orElse(0.0))).nullifyNegatives();
        this.localInternalBoundingBox = new BoundingBox(origin, size);
    }

    private void updateAbsoluteInternalBoundingBox() {
        Vector2d origin = this.absoluteBoundingBox.getLocalOrigin().move(this.getPadding().getLeft().orElse(0.0).doubleValue(), this.getPadding().getTop().orElse(0.0).doubleValue());
        Vector2d size = this.absoluteBoundingBox.getSize().move(-1.0 * (this.getPadding().getLeft().orElse(0.0) + this.getPadding().getRight().orElse(0.0)), -1.0 * (this.getPadding().getTop().orElse(0.0) + this.getPadding().getBottom().orElse(0.0))).nullifyNegatives();
        this.absoluteInternalBoundingBox = new BoundingBox(origin, size);
    }

    public AxisDistance getPadding() {
        return (AxisDistance)this.padding.get((IDependencyReceiver)this);
    }

    public void setPadding(@NotNull AxisDistance padding) {
        this.padding.set((IDependencyReceiver)this, (Object)padding);
    }

    public BoundingBox getLocalInternalBoundingBox() {
        return this.localInternalBoundingBox;
    }

    public BoundingBox getAbsoluteInternalBoundingBox() {
        return this.absoluteInternalBoundingBox;
    }

    public static abstract class AbstractChildrenContainingUIElementFactory<U extends IUIElementHost>
    extends AbstractSimpleUIElement.AbstractSimpleUIElementFactory<U> {
        protected AbstractChildrenContainingUIElementFactory(Class<U> clz, String type, @NotNull IChildrenContainingUIElementConstructor<U> constructor, @NotNull AbstractSimpleUIElement.AbstractSimpleUIElementFactory.ISimpleUIElementWriter<U> writer) {
            super(clz, type, (IUIElementData<?> elementData, IBindingEngine engine, String id, IUIElementHost parent, IDependencyObject<IIdentifier> styleId, IDependencyObject<EnumSet<Alignment>> alignments, IDependencyObject<Dock> dock, IDependencyObject<AxisDistance> margin, IDependencyObject<Vector2d> elementSize, IDependencyObject<Object> dataContext, IDependencyObject<Boolean> visible, IDependencyObject<Boolean> enabled) -> {
                IDependencyObject padding = elementData.getFromRawDataWithDefault("padding", engine, (Object)AxisDistance.DEFAULT, AxisDistance.class, new Object[0]);
                IUIElementHost element = (IUIElementHost)constructor.constructUsing(elementData, engine, id, parent, (IDependencyObject<IIdentifier>)styleId, (IDependencyObject<EnumSet<Alignment>>)alignments, (IDependencyObject<Dock>)dock, (IDependencyObject<AxisDistance>)margin, (IDependencyObject<AxisDistance>)padding, (IDependencyObject<Vector2d>)elementSize, (IDependencyObject<Object>)dataContext, (IDependencyObject<Boolean>)visible, (IDependencyObject<Boolean>)enabled);
                ((ArrayList)elementData.getFromRawDataWithDefault("children", engine, new ArrayList(), Constants.ConverterTypes.CHILDREN_LIST_TYPE, new Object[]{element}).get((IDependencyReceiver)element)).forEach(childData -> {
                    IUIElement child = ProxyHolder.getInstance().getFactoryController().getElementFromData(childData);
                    element.put((Object)child.getId(), (Object)child);
                });
                return element;
            }, (U element, IUIElementDataBuilder<?> builder) -> {
                writer.write(element, builder);
                builder.addComponent("padding", (Object)element.getPadding(), AxisDistance.class);
                element.values().forEach(arg_0 -> ((IUIElementDataBuilder)builder).addChild(arg_0));
            });
        }

        @FunctionalInterface
        protected static interface IChildrenContainingUIElementConstructor<U extends IUIElement> {
            public U constructUsing(@NotNull IUIElementData<?> var1, @NotNull IBindingEngine var2, @NotNull String var3, @Nullable IUIElementHost var4, @NotNull IDependencyObject<IIdentifier> var5, @NotNull IDependencyObject<EnumSet<Alignment>> var6, @NotNull IDependencyObject<Dock> var7, @NotNull IDependencyObject<AxisDistance> var8, @NotNull IDependencyObject<AxisDistance> var9, @NotNull IDependencyObject<Vector2d> var10, @NotNull IDependencyObject<Object> var11, @NotNull IDependencyObject<Boolean> var12, @NotNull IDependencyObject<Boolean> var13);
        }
    }

    public static abstract class SimpleControlConstructionDataBuilder<B extends SimpleControlConstructionDataBuilder<B, S>, S extends AbstractChildrenContainingUIElement>
    implements IBlockOutUIElementConstructionDataBuilder<B, S> {
        private final String controlId;
        private final IBlockOutGuiConstructionDataBuilder data;
        private final Class<S> controlClass;

        protected SimpleControlConstructionDataBuilder(String controlId, IBlockOutGuiConstructionDataBuilder data, Class<S> controlClass) {
            this.controlId = controlId;
            this.data = data;
            this.controlClass = controlClass;
        }

        @NotNull
        public B withDependentAllignments(@NotNull IDependencyObject<EnumSet<Alignment>> alignments) {
            return (B)this.withDependency("alignments", (IDependencyObject)alignments);
        }

        @NotNull
        public B withDependency(@NotNull String fieldName, @NotNull IDependencyObject<?> dependency) {
            this.data.withDependency(this.controlId, fieldName, dependency);
            return (B)this;
        }

        @NotNull
        public <A> B withEventHandler(@NotNull String eventName, @NotNull Class<A> argumentTypeClass, @NotNull IEventHandler<S, A> eventHandler) {
            this.data.withEventHandler(this.controlId, eventName, this.controlClass, argumentTypeClass, eventHandler);
            return (B)this;
        }

        @NotNull
        public B withDependentDock(@NotNull IDependencyObject<Dock> dock) {
            return (B)this.withDependency("dock", (IDependencyObject)dock);
        }

        @NotNull
        public B withDependentMargin(@NotNull IDependencyObject<AxisDistance> margin) {
            return (B)this.withDependency("margin", (IDependencyObject)margin);
        }

        @NotNull
        public B withDependentSize(@NotNull IDependencyObject<Vector2d> elementSize) {
            return (B)this.withDependency("elementSize", (IDependencyObject)elementSize);
        }

        @NotNull
        public B withDependentDataContext(@NotNull IDependencyObject<Object> dataContext) {
            return (B)this.withDependency("dataContext", (IDependencyObject)dataContext);
        }

        @NotNull
        public B withDependentVisibility(@NotNull IDependencyObject<Boolean> visible) {
            return (B)this.withDependency("visible", (IDependencyObject)visible);
        }

        @NotNull
        public B withDependentEnablement(@NotNull IDependencyObject<Boolean> enabled) {
            return (B)this.withDependency("enabled", (IDependencyObject)enabled);
        }

        @NotNull
        public B withAllignments(@NotNull EnumSet<Alignment> alignments) {
            return (B)this.withDependency("alignments", DependencyObjectHelper.createFromValue(alignments));
        }

        @NotNull
        public B withDock(@NotNull Dock dock) {
            return (B)this.withDependency("dock", DependencyObjectHelper.createFromValue((Object)dock));
        }

        @NotNull
        public B withMargin(@NotNull AxisDistance margin) {
            return (B)this.withDependency("margin", DependencyObjectHelper.createFromValue((Object)margin));
        }

        @NotNull
        public B withSize(@NotNull Vector2d elementSize) {
            return (B)this.withDependency("elementSize", DependencyObjectHelper.createFromValue((Object)elementSize));
        }

        @NotNull
        public B withDataContext(@NotNull Object dataContext) {
            return (B)this.withDependency("dataContext", DependencyObjectHelper.createFromValue((Object)dataContext));
        }

        @NotNull
        public B withVisibility(@NotNull Boolean visible) {
            return (B)this.withDependency("visible", DependencyObjectHelper.createFromValue((Object)visible));
        }

        @NotNull
        public B withEnablement(@NotNull Boolean enabled) {
            return (B)this.withDependency("enabled", DependencyObjectHelper.createFromValue((Object)enabled));
        }
    }
}

