/*
 * Decompiled with CFR 0.152.
 */
package com.Zeno410Utils;

import java.lang.reflect.Field;

public class Accessor<ObjectType, FieldType> {
    private Field field;
    private final String fieldName;

    public Accessor(String _fieldName) {
        this.fieldName = _fieldName;
    }

    private Field field(ObjectType example) {
        Class<?> classObject = example.getClass();
        if (this.field == null) {
            try {
                this.setField(classObject);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.field;
    }

    private void setField(Class classObject) throws IllegalAccessException {
        do {
            Field[] fields = classObject.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().contains(this.fieldName)) continue;
                this.field = fields[i];
                this.field.setAccessible(true);
                return;
            }
        } while ((classObject = classObject.getSuperclass()) != Object.class);
        throw new RuntimeException(this.fieldName + " not found in class " + classObject.getName());
    }

    public FieldType get(ObjectType object) {
        try {
            return (FieldType)this.field(object).get(object);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setField(ObjectType object, FieldType fieldValue) {
        try {
            this.field(object).set(object, fieldValue);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

