/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.DimensionManager;
import climateControl.LockGenLayers;
import com.Zeno410Utils.Accessor;
import com.Zeno410Utils.Maybe;
import com.Zeno410Utils.Zeno410Logger;
import java.util.logging.Logger;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;

public class GenLayerRiverMixWrapper
extends GenLayerRiverMix {
    public static Logger logger = new Zeno410Logger("GenLayerRiverMixWrapper").logger();
    private GenLayer redirect;
    private GenLayer voronoi;
    private GenLayer original;
    private Accessor<GenLayerRiverMix, GenLayer> riverMixBiome = new Accessor("field_75910_b");
    private LockGenLayers biomeLocker = new LockGenLayers();
    private DimensionManager dimensionManager;
    private boolean found = false;

    private static GenLayer dummyGenLayer() {
        return new GenLayer(0L){

            public int[] func_75904_a(int var1, int var2, int var3, int var4) {
                return new int[var3 * var4];
            }
        };
    }

    public GenLayerRiverMixWrapper(long baseSeed, GenLayer nonGCLayers, DimensionManager dimensionManager) {
        super(baseSeed, GenLayerRiverMixWrapper.dummyGenLayer(), GenLayerRiverMixWrapper.dummyGenLayer());
        this.voronoi = new GenLayerVoronoiZoom(baseSeed, (GenLayer)this);
        this.original = nonGCLayers;
        this.dimensionManager = dimensionManager;
    }

    private void findSelf() {
        Integer[] dimensions;
        if (this.found) {
            return;
        }
        for (Integer dimension : dimensions = net.minecraftforge.common.DimensionManager.getIDs()) {
            BiomeProvider provider = net.minecraftforge.common.DimensionManager.getProvider((int)dimension).func_177499_m();
            GenLayer topLayer = this.workingGenLayer(provider);
            if (topLayer == this) {
                logger.info(topLayer.toString() + " dimension " + dimension);
                this.found = true;
                WorldServer world = net.minecraftforge.common.DimensionManager.getWorld((int)dimension);
                Maybe<GenLayerRiverMix> gcLayers = this.dimensionManager.getGeographicraftGenlayers(world, dimension, this.original);
                this.redirect = gcLayers.isKnown() ? (GenLayer)gcLayers.iterator().next() : this.original;
                return;
            }
            logger.info(dimension + " not a match for " + this.original.toString());
        }
        this.found = true;
        this.redirect = this.original;
    }

    private GenLayer workingGenLayer(BiomeProvider provider) {
        Accessor worldGenLayer = new Accessor("field_76944_d");
        return (GenLayer)worldGenLayer.get(provider);
    }

    public int[] func_75904_a(int arg0, int arg1, int arg2, int arg3) {
        this.findSelf();
        return this.redirect.func_75904_a(arg0, arg1, arg2, arg3);
    }

    public void func_75903_a(long par1, long par3) {
        super.func_75903_a(par1, par3);
        this.findSelf();
        this.redirect.func_75903_a(par1, par3);
    }

    public void func_75905_a(long arg0) {
        super.func_75905_a(arg0);
        this.findSelf();
        this.redirect.func_75905_a(arg0);
    }

    public GenLayer voronoi() {
        return this.voronoi;
    }

    public GenLayer[] modifiedGenerators() {
        return new GenLayer[]{this, this.voronoi, this};
    }
}

