/*
 * Decompiled with CFR 0.152.
 */
package climateControl.customGenLayer;

import climateControl.customGenLayer.PlaneLocatedRecorder;
import climateControl.genLayerPack.GenLayerPack;
import com.Zeno410Utils.PlaneLocated;
import com.Zeno410Utils.PlaneLocation;
import java.io.DataOutputStream;
import java.util.ArrayList;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class GenLayerLimitedCache
extends GenLayerPack {
    private PlaneLocated<Integer> storedVals = new PlaneLocated();
    private PlaneLocatedRecorder target;
    private final int limit;
    private final ArrayList<PlaneLocation> currentStored;
    int nextSlot = 0;
    boolean full = false;

    public GenLayerLimitedCache(GenLayer parent, int limit) {
        super(0L);
        this.field_75909_a = parent;
        this.limit = limit;
        this.currentStored = new ArrayList(limit);
        this.currentStored.ensureCapacity(limit);
    }

    public GenLayerLimitedCache(GenLayer parent, DataOutputStream target, int limit) {
        this(parent, limit);
        this.field_75909_a = parent;
        this.target = new PlaneLocatedRecorder(target);
    }

    @Override
    public void func_75905_a(long par1) {
        if (this.target != null) {
            this.target.writeSeed(par1);
        }
        super.func_75905_a(par1);
    }

    @Override
    public int[] func_75904_a(int x0, int z0, int xSize, int zSize) {
        PlaneLocation.Probe probe = new PlaneLocation.Probe(x0, z0);
        int[] parentInts = null;
        int[] result = IntCache.func_76445_a((int)(xSize * zSize));
        for (int x = 0; x < xSize; ++x) {
            probe.setX(x + x0);
            for (int z = 0; z < zSize; ++z) {
                probe.setZ(z + z0);
                Integer locked = this.storedVals.get(probe);
                if (locked == null) {
                    if (parentInts == null) {
                        parentInts = this.field_75909_a.func_75904_a(x0, z0, xSize, zSize);
                    }
                    locked = (int)parentInts[z * xSize + x];
                    result[z * xSize + x] = locked;
                    PlaneLocation location = new PlaneLocation(probe.x(), probe.z());
                    if (this.full) {
                        PlaneLocation oldLocation = this.currentStored.get(this.nextSlot);
                        this.storedVals.remove(oldLocation);
                    }
                    this.storedVals.put(location, locked);
                    if (this.full) {
                        this.currentStored.set(this.nextSlot, location);
                    } else {
                        this.currentStored.add(location);
                    }
                    if (this.nextSlot++ < this.limit) continue;
                    this.nextSlot = 0;
                    this.full = true;
                    continue;
                }
                result[z * xSize + x] = locked;
            }
        }
        if (this.target != null) {
            this.target.accept(this.storedVals);
        }
        return result;
    }
}

