/*
 * Decompiled with CFR 0.152.
 */
package climateControl.biomeSettings;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.common.init.ModBiomes;
import climateControl.api.BiomeSettings;
import climateControl.api.Climate;
import climateControl.api.ClimateControlRules;
import climateControl.api.ClimateDistribution;
import climateControl.biomeSettings.BiomeReplacer;
import climateControl.biomeSettings.OceanBiomeSettings;
import climateControl.biomeSettings.VanillaBiomeSettings;
import climateControl.generator.SubBiomeChooser;
import com.Zeno410Utils.Acceptor;
import com.Zeno410Utils.Mutable;
import com.google.common.base.Optional;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Biomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;

public class BoPSettings
extends BiomeSettings {
    public final BiomeSettings.Element alps;
    public final BiomeSettings.Element bambooForest;
    public final BiomeSettings.Element bayou;
    public final BiomeSettings.Element bog;
    public final BiomeSettings.Element borealForest;
    public final BiomeSettings.Element brushland;
    public final BiomeSettings.Element chaparral;
    public final BiomeSettings.Element cherryBlossomGrove;
    public final BiomeSettings.Element coldDesert;
    public final BiomeSettings.Element coniferousForest;
    public final BiomeSettings.Element coralReef;
    public final BiomeSettings.Element crag;
    public final BiomeSettings.Element deadForest;
    public final BiomeSettings.Element deadSwamp;
    public final BiomeSettings.Element fen;
    public final BiomeSettings.Element flowerField;
    public final BiomeSettings.Element flowerIsland;
    public final BiomeSettings.Element glacier;
    public final BiomeSettings.Element grassland;
    public final BiomeSettings.ID gravelBeach;
    public final BiomeSettings.Element grove;
    public final BiomeSettings.Element heathland;
    public final BiomeSettings.Element highland;
    public final BiomeSettings.Element kelpForest;
    public final BiomeSettings.Element lavenderFields;
    public final BiomeSettings.Element lushDesert;
    public final BiomeSettings.Element lushSwamp;
    public final BiomeSettings.Element mangrove;
    public final BiomeSettings.Element mapleWoods;
    public final BiomeSettings.Element marsh;
    public final BiomeSettings.Element meadow;
    public final BiomeSettings.Element moor;
    public final BiomeSettings.Element mountain;
    public final BiomeSettings.Element mountainFoothills;
    public final BiomeSettings.Element mysticGrove;
    public final BiomeSettings.ID oasis;
    public final BiomeSettings.Element ominousWoods;
    public final BiomeSettings.Element orchard;
    public final BiomeSettings.Element originVally;
    public final BiomeSettings.Element outback;
    public final BiomeSettings.Element overgrownCliffs;
    public final BiomeSettings.Element prairie;
    public final BiomeSettings.Element quagmire;
    public final BiomeSettings.Element rainforest;
    public final BiomeSettings.Element redwoodForest;
    public final BiomeSettings.Element sacredSprings;
    public final BiomeSettings.ID savanna;
    public final BiomeSettings.ID savannaPlateau;
    public final BiomeSettings.Element seasonalForest;
    public final BiomeSettings.Element shield;
    public final BiomeSettings.Element shrubland;
    public final BiomeSettings.Element snowyConiferousForest;
    public final BiomeSettings.Element snowyForest;
    public final BiomeSettings.Element steppe;
    public final BiomeSettings.Element temperateRainforest;
    public final BiomeSettings.Element tropicalRainforest;
    public final BiomeSettings.Element tropicalIslands;
    public final BiomeSettings.Element tundra;
    public final BiomeSettings.Element volcano;
    public final BiomeSettings.Element wasteland;
    public final BiomeSettings.Element wetland;
    public final BiomeSettings.Element woodland;
    public final BiomeSettings.Element eucalyptusForest;
    public final BiomeSettings.Element landOfLakes;
    public final BiomeSettings.Element xericShrubland;
    Acceptor<Integer> crashOnZero;
    Acceptor<Integer> crashOnNegative;
    private HashMap<BiomeSettings.ID, BiomeReplacer.Variable> subBiomeSets;
    static final String biomesOnName = "BoPBiomesOn";
    public final Mutable<Boolean> biomesFromConfig;
    static final String configName = "BoP";
    public final Mutable<Boolean> biomesInNewWorlds;

    public BoPSettings() {
        super(configName);
        this.alps = (BiomeSettings)this.new BiomeSettings.Element("Alps", 177, 5, Climate.SNOWY.name);
        this.bambooForest = new BiomeSettings.Element("Bamboo Forest", 180, 5, true, "WARM");
        this.bayou = new BiomeSettings.Element("Bayou", 181, 10, true, "WARM");
        this.bog = new BiomeSettings.Element("Bog", 183, 7, true, "COOL");
        this.borealForest = new BiomeSettings.Element("Boreal Forest", 184, 10, true, "COOL");
        this.brushland = new BiomeSettings.Element("Brushland", 185, 7, true, "WARM");
        this.chaparral = new BiomeSettings.Element("Chaparral", 187, 10, true, "WARM");
        this.cherryBlossomGrove = new BiomeSettings.Element("Cherry Blossom Grove", 188, 3, true, "COOL");
        this.coldDesert = new BiomeSettings.Element("Cold Desert", 255, 10, true, "SNOWY");
        this.coniferousForest = new BiomeSettings.Element("Coniferous Forest", 189, 10, true, "WARM");
        this.coralReef = (BiomeSettings)this.new BiomeSettings.Element("Coral Reef", 94, 0, "OCEAN");
        this.crag = (BiomeSettings)this.new BiomeSettings.Element("Crag", 191, 3, "MEDIUM");
        this.deadForest = new BiomeSettings.Element("Dead Forest", 192, 7, true, "COOL");
        this.deadSwamp = new BiomeSettings.Element("Dead Swamp", 194, 7, true, "WARM");
        this.fen = (BiomeSettings)this.new BiomeSettings.Element("Fen", 198, true, "WARM");
        this.flowerField = new BiomeSettings.Element("Flower Field", 199, 3, true, "WARM");
        this.flowerIsland = new BiomeSettings.Element("Flower Island", 255, 1, true, "DEEP_OCEAN");
        this.glacier = (BiomeSettings)this.new BiomeSettings.Element("Glacier", 203, 0, "SNOWY");
        this.grassland = (BiomeSettings)this.new BiomeSettings.Element("Grassland", 204, true, "COOL");
        this.gravelBeach = (BiomeSettings)this.new BiomeSettings.ID("Gravel Beach", 75);
        this.grove = (BiomeSettings)this.new BiomeSettings.Element("Grove", 205, 5, "COOL");
        this.heathland = (BiomeSettings)this.new BiomeSettings.Element("Heathland", 206, "COOL");
        this.highland = (BiomeSettings)this.new BiomeSettings.Element("Highland", 210, "COOL");
        this.kelpForest = (BiomeSettings)this.new BiomeSettings.Element("Kelp Forest", 95, 0, "OCEAN");
        this.lavenderFields = (BiomeSettings)this.new BiomeSettings.Element("Lavender Fields", 56, 3, "WARM");
        this.lushDesert = new BiomeSettings.Element("Lush Desert", 214, 3, true, "HOT");
        this.lushSwamp = (BiomeSettings)this.new BiomeSettings.Element("Lush Swamp", 215, true, "WARM");
        this.mangrove = (BiomeSettings)this.new BiomeSettings.Element("Mangrove", 216, 3, "WARM");
        this.mapleWoods = (BiomeSettings)this.new BiomeSettings.Element("Maple Woods", 217, true, "COOL");
        this.marsh = new BiomeSettings.Element("Marsh", 218, 7, true, "COOL");
        this.meadow = (BiomeSettings)this.new BiomeSettings.Element("Meadow", 219, true, "COOL");
        this.moor = (BiomeSettings)this.new BiomeSettings.Element("Moor", 221, true, "COOL");
        this.mountain = (BiomeSettings)this.new BiomeSettings.Element("Mountain", 222, 8, "WARM");
        this.mountainFoothills = (BiomeSettings)this.new BiomeSettings.Element("Mountain Foothills", 93, 2, "WARM");
        this.mysticGrove = (BiomeSettings)this.new BiomeSettings.Element("Mystic Grove", 223, 3, "MEDIUM");
        this.oasis = (BiomeSettings)this.new BiomeSettings.ID("Oasis", 224);
        this.ominousWoods = (BiomeSettings)this.new BiomeSettings.Element("Ominous Woods", 225, 3, "COOL");
        this.orchard = (BiomeSettings)this.new BiomeSettings.Element("Orchard", 226, 5, ClimateDistribution.MEDIUM.name());
        this.originVally = (BiomeSettings)this.new BiomeSettings.Element("Origin Valley", 227, 1, "MEDIUM");
        this.outback = new BiomeSettings.Element("Outback", 228, 7, true, "HOT");
        this.overgrownCliffs = new BiomeSettings.Element("Overgrown Cliffs", 255, 7, true, ClimateDistribution.MEDIUM.name());
        this.prairie = (BiomeSettings)this.new BiomeSettings.Element("Prairie", 231, true, "WARM");
        this.quagmire = (BiomeSettings)this.new BiomeSettings.Element("Quagmire", 232, 3, "COOL");
        this.rainforest = new BiomeSettings.Element("Rainforest", 233, 5, true, "WARM");
        this.redwoodForest = new BiomeSettings.Element("Redwood Forest", 234, 7, true, "COOL");
        this.sacredSprings = (BiomeSettings)this.new BiomeSettings.Element("Sacred Springs", 235, 3, ClimateDistribution.MEDIUM.name());
        this.savanna = (BiomeSettings)this.new BiomeSettings.ID("Savanna", 236);
        this.savannaPlateau = (BiomeSettings)this.new BiomeSettings.ID("Savanna Plateau (Sub-Biome)", 61);
        this.seasonalForest = (BiomeSettings)this.new BiomeSettings.Element("Seasonal Forest", 238, true, "COOL");
        this.shield = new BiomeSettings.Element("Shield", 239, 7, true, "COOL");
        this.shrubland = (BiomeSettings)this.new BiomeSettings.Element("Shrubland", 241, true, "COOL");
        this.snowyConiferousForest = (BiomeSettings)this.new BiomeSettings.Element("Snowy Coniferous Forest", 51, true, "SNOWY");
        this.snowyForest = (BiomeSettings)this.new BiomeSettings.Element("Snowy Forest", 51, true, "SNOWY");
        this.steppe = new BiomeSettings.Element("Steppe", 244, 7, true, Climate.COOL.name);
        this.temperateRainforest = (BiomeSettings)this.new BiomeSettings.Element("Temperate Rainforest", 245, true, "WARM");
        this.tropicalRainforest = new BiomeSettings.Element("Tropical Rainforest", 248, 5, true, "HOT");
        this.tropicalIslands = new BiomeSettings.Element("Tropical Islands", 249, 1, true, "DEEP_OCEAN");
        this.tundra = new BiomeSettings.Element("Tundra", 250, 7, true, "SNOWY");
        this.volcano = new BiomeSettings.Element("Volcanic Island", 251, 1, true, "DEEP_OCEAN");
        this.wasteland = (BiomeSettings)this.new BiomeSettings.Element("Wasteland", 252, 3, "HOT");
        this.wetland = new BiomeSettings.Element("Wetland", 253, 7, true, "WARM");
        this.woodland = (BiomeSettings)this.new BiomeSettings.Element("Woodland", 254, true, "WARM");
        this.eucalyptusForest = (BiomeSettings)this.new BiomeSettings.Element("Eucalyptus Forest", 57, false, "WARM");
        this.landOfLakes = (BiomeSettings)this.new BiomeSettings.Element("Land of Lakes", 68, false, "COOL");
        this.xericShrubland = (BiomeSettings)this.new BiomeSettings.Element("Xeric Shrubland", 98, false, "HOT");
        this.crashOnZero = new Acceptor<Integer>(){

            @Override
            public void accept(Integer accepted) {
                throw new RuntimeException("Thicket incidence " + accepted);
            }
        };
        this.crashOnNegative = new Acceptor<Integer>(){

            @Override
            public void accept(Integer accepted) {
                throw new RuntimeException("Thicket ID " + accepted);
            }
        };
        this.subBiomeSets = new HashMap();
        this.biomesFromConfig = this.climateControlCategory.booleanSetting(biomesOnName, "", false);
        this.biomesInNewWorlds = this.climateControlCategory.booleanSetting(this.startBiomesName(configName), "Use biome in new worlds and dimensions", true);
    }

    @Override
    public boolean activeIn(WorldType worldType) {
        if (worldType.func_77127_a().equalsIgnoreCase("BIOMESOP")) {
            return true;
        }
        return worldType.func_77127_a().equalsIgnoreCase("RTG");
    }

    private int bopID(Optional<Biome> bopBiome) {
        try {
            return Biome.func_185362_a((Biome)((Biome)bopBiome.get()));
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    @Override
    public void setNativeBiomeIDs(File configDirectory) {
        try {
            this.alps.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.alps));
            this.bambooForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.bamboo_forest));
            this.bayou.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.bayou));
            this.bog.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.bog));
            this.borealForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.boreal_forest));
            this.brushland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.brushland));
            this.chaparral.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.chaparral));
            this.cherryBlossomGrove.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.cherry_blossom_grove));
            this.coniferousForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.coniferous_forest));
            this.coldDesert.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.cold_desert));
            this.coralReef.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.coral_reef));
            this.crag.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.crag));
            this.deadForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.dead_forest));
            this.deadSwamp.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.dead_swamp));
            this.fen.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.fen));
            this.flowerField.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.flower_field));
            this.flowerIsland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.flower_island));
            this.grassland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.grassland));
            this.glacier.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.glacier));
            this.gravelBeach.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.gravel_beach));
            this.grove.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.grove));
            try {
                this.heathland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.heathland));
            }
            catch (NoSuchFieldError e) {
                this.heathland.biomeID().set(-1);
            }
            this.highland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.highland));
            this.kelpForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.kelp_forest));
            this.lavenderFields.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.lavender_fields));
            this.lushDesert.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.lush_desert));
            this.lushSwamp.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.lush_swamp));
            this.mangrove.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.mangrove));
            this.mapleWoods.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.maple_woods));
            this.marsh.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.marsh));
            this.meadow.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.meadow));
            this.mysticGrove.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.mystic_grove));
            this.moor.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.moor));
            this.mountain.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.mountain));
            this.mountainFoothills.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.mountain_foothills));
            this.ominousWoods.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.ominous_woods));
            this.oasis.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.oasis));
            this.orchard.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.orchard));
            this.originVally.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.origin_island));
            this.outback.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.outback));
            this.overgrownCliffs.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.overgrown_cliffs));
            this.prairie.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.prairie));
            this.quagmire.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.quagmire));
            this.rainforest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.rainforest));
            this.redwoodForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.redwood_forest));
            this.sacredSprings.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.sacred_springs));
            this.savanna.setIDFrom(Biomes.field_150588_X);
            this.savannaPlateau.setIDFrom(Biomes.field_150587_Y);
            this.seasonalForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.seasonal_forest));
            this.shield.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.shield));
            this.shrubland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.shrubland));
            this.snowyConiferousForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.snowy_coniferous_forest));
            this.snowyForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.snowy_forest));
            this.steppe.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.steppe));
            this.temperateRainforest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.temperate_rainforest));
            this.tropicalRainforest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.tropical_rainforest));
            this.tropicalIslands.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.tropical_island));
            this.tundra.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.tundra));
            this.volcano.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.volcanic_island));
            this.wasteland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.wasteland));
            this.wetland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.wetland));
            this.woodland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.woodland));
            this.eucalyptusForest.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.eucalyptus_forest));
            this.landOfLakes.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.land_of_lakes));
            this.xericShrubland.biomeID().set(this.bopID((Optional<Biome>)BOPBiomes.xeric_shrubland));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public BiomeReplacer.Variable getCommonSubBiome(BiomeSettings.ID biome) {
        List subBiomeIds = (List)ModBiomes.subBiomesMap.get(biome.biomeID());
        BiomeReplacer.Variable result = new BiomeReplacer.Variable();
        if (subBiomeIds == null || subBiomeIds.size() == 0) {
            result.add(biome, 1);
        } else {
            int n = subBiomeIds.size();
            for (int i = 0; i < n; ++i) {
                result.add(biome, 1);
                result.addByNumber((Integer)subBiomeIds.get(i), 1);
            }
        }
        return result;
    }

    private BiomeReplacer.Variable subBiomeSet(BiomeSettings.ID biome) {
        BiomeReplacer.Variable result = this.subBiomeSets.get(biome);
        if (result == null) {
            result = this.getCommonSubBiome(biome);
            this.subBiomeSets.put(biome, result);
        }
        return result;
    }

    private void addSubBiome(BiomeSettings.ID biome, BiomeSettings.ID subBiome) {
        if (subBiome.active()) {
            this.subBiomeSet(biome).add(subBiome, 1);
            biome.setSubBiomeChooser(this.subBiomeSet(biome));
        }
    }

    @Override
    public void arrangeInteractions(ArrayList<BiomeSettings> biomeSettings) {
        this.subBiomeSets = new HashMap();
        for (BiomeSettings biomeSetting : biomeSettings) {
            BiomeReplacer desertReplacer;
            BiomeReplacer.Variable newReplacer;
            if (biomeSetting instanceof OceanBiomeSettings) {
                OceanBiomeSettings oceanSettings = (OceanBiomeSettings)biomeSetting;
                BiomeReplacer oldReplacer = oceanSettings.coastalOcean.subBiomeChooser();
                newReplacer = new BiomeReplacer.Variable();
                if (this.coralReef.active()) {
                    newReplacer.add(this.coralReef, 1);
                    newReplacer.add(oceanSettings.coastalOcean, 1);
                }
                if (this.kelpForest.active()) {
                    newReplacer.add(this.kelpForest, 1);
                    newReplacer.add(oceanSettings.coastalOcean, 1);
                }
                if (this.coralReef.active() || this.kelpForest.active()) {
                    oceanSettings.coastalOcean.setSubBiomeChooser(newReplacer);
                }
            }
            if (!(biomeSetting instanceof VanillaBiomeSettings)) continue;
            VanillaBiomeSettings vanillaSettings = (VanillaBiomeSettings)biomeSetting;
            BiomeReplacer icePlainsReplacer = vanillaSettings.icePlains.subBiomeChooser();
            if (icePlainsReplacer instanceof BiomeReplacer.Fixed) {
                newReplacer = new BiomeReplacer.Variable();
                newReplacer.add(this.glacier, 1);
                newReplacer.add(vanillaSettings.iceMountains, 1);
                vanillaSettings.icePlains.setSubBiomeChooser(newReplacer);
            }
            if (!((desertReplacer = vanillaSettings.desert.subBiomeChooser()) instanceof BiomeReplacer.Fixed)) continue;
            BiomeReplacer.Variable newReplacer2 = new BiomeReplacer.Variable();
            newReplacer2.add(this.oasis, 1);
            newReplacer2.add(vanillaSettings.desertHills, 3);
            vanillaSettings.desert.setSubBiomeChooser(newReplacer2);
        }
    }

    @Override
    public void update(SubBiomeChooser subBiomeChooser) {
        super.update(subBiomeChooser);
        for (BiomeSettings.Element element : this.elements()) {
            subBiomeChooser.set(element.biomeID().value(), this.subBiomeSet(element));
        }
    }

    @Override
    public void setRules(ClimateControlRules rules) {
        rules.noBeaches(this.coralReef.biomeID().value());
        rules.noBeaches(this.kelpForest.biomeID().value());
        this.setVillages(rules);
    }

    @Override
    public void onNewWorld() {
        this.biomesFromConfig.set(this.biomesInNewWorlds);
    }

    @Override
    public boolean biomesAreActive() {
        return this.biomesFromConfig.value();
    }
}

