/*
 * Decompiled with CFR 0.152.
 */
package climateControl.api;

import com.Zeno410Utils.Acceptor;
import com.Zeno410Utils.DimensionSet;
import com.Zeno410Utils.Mutable;
import com.Zeno410Utils.Named;
import com.Zeno410Utils.Settings;

public class CCDimensionSettings
extends Settings {
    public final Mutable<String> excludeDimensions = this.general().stringSetting("excludeDimensionIDs", "-1,1", "Comma-separated list of dimension IDs, used only if include list is *");
    public final Mutable<String> includeDimensions = this.general().stringSetting("includeDimensionIDs", "0", "Comma-separated list of dimension IDs, put * to use exclude list");
    private DimensionSet.Exclude excludedDimensions = new DimensionSet.Exclude(this.excludeDimensions.value());
    private DimensionSet.Include includedDimensions = new DimensionSet.Include(this.includeDimensions.value());
    private Acceptor<String> excludeUpdater = new Acceptor<String>(){

        @Override
        public void accept(String accepted) {
            CCDimensionSettings.this.excludedDimensions = new DimensionSet.Exclude(accepted);
        }
    };
    private Acceptor<String> includeUpdater = new Acceptor<String>(){

        @Override
        public void accept(String accepted) {
            CCDimensionSettings.this.includedDimensions = new DimensionSet.Include(accepted);
        }
    };

    public final Named<CCDimensionSettings> named() {
        return Named.from("CCDimensions.cfg", this);
    }

    public CCDimensionSettings() {
        this.excludeDimensions.informOnChange(this.excludeUpdater);
        this.includeDimensions.informOnChange(this.includeUpdater);
    }

    public boolean ccOnIn(Integer dimension) {
        return this.includedDimensions.isIncluded(dimension, this.excludedDimensions);
    }
}

