/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.block;

import com.google.common.base.Predicate;
import doggytalents.ModCreativeTabs;
import doggytalents.api.inferface.IBedMaterial;
import doggytalents.block.DogBedRegistry;
import doggytalents.block.PropertyString;
import doggytalents.client.model.block.IStateParticleModel;
import doggytalents.client.renderer.particle.ParticleCustomDigging;
import doggytalents.network.PacketDispatcher;
import doggytalents.network.client.CustomParticleMessage;
import doggytalents.tileentity.TileEntityDogBed;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDogBed
extends BlockContainer {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6, 1.0);
    protected static final AxisAlignedBB AABB_COLLISION = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyString CASING = PropertyString.create("casing");
    public static final PropertyString BEDDING = PropertyString.create("bedding");
    public final ThreadLocal<ItemStack> drops = new ThreadLocal();

    public BlockDogBed() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(ModCreativeTabs.DOG_BED);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDogBed();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB_COLLISION;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            IBedMaterial casingId = DogBedRegistry.CASINGS.get(tag.func_74779_i("casingId"));
            IBedMaterial beddingId = DogBedRegistry.BEDDINGS.get(tag.func_74779_i("beddingId"));
            tooltip.add(casingId.getTooltip().func_150254_d());
            tooltip.add(beddingId.getTooltip().func_150254_d());
        }
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (IBedMaterial beddingId : DogBedRegistry.BEDDINGS.getKeys()) {
            for (IBedMaterial casingId : DogBedRegistry.CASINGS.getKeys()) {
                items.add((Object)DogBedRegistry.createItemStack(casingId, beddingId));
            }
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("doggytalents")) {
            NBTTagCompound tag = stack.func_77978_p().func_74775_l("doggytalents");
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileEntityDogBed) {
                TileEntityDogBed dogBed = (TileEntityDogBed)tile;
                dogBed.setBeddingId(DogBedRegistry.BEDDINGS.get(tag.func_74779_i("beddingId")));
                dogBed.setCasingId(DogBedRegistry.CASINGS.get(tag.func_74779_i("casingId")));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getStateForEntityRender(IBlockState state) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.SOUTH);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{FACING}, new IUnlistedProperty[]{CASING, BEDDING});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityDogBed && state instanceof IExtendedBlockState) {
            IExtendedBlockState stateExtended = (IExtendedBlockState)state;
            TileEntityDogBed dogBed = (TileEntityDogBed)te;
            return stateExtended.withProperty((IUnlistedProperty)CASING, (Object)dogBed.getCasingId().getSaveId()).withProperty((IUnlistedProperty)BEDDING, (Object)dogBed.getBeddingId().getSaveId());
        }
        return super.getExtendedState(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getMixedBrightnessForBlock(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_175626_b(pos, 0);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityDogBed) {
            TileEntityDogBed dogBed = (TileEntityDogBed)tileentity;
            if (!playerIn.field_71075_bZ.field_75098_d) {
                this.drops.set(DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityDogBed)) {
            return ItemStack.field_190927_a;
        }
        TileEntityDogBed dogBed = (TileEntityDogBed)tile;
        return DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!this.canBlockStay(worldIn, pos)) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileEntityDogBed) {
                TileEntityDogBed dogBed = (TileEntityDogBed)tile;
                BlockDogBed.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            }
            worldIn.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        IBlockState blockstate = world.func_180495_p(pos.func_177977_b());
        return blockstate.func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess worldIn, BlockPos pos, IBlockState state, int fortune) {
        ItemStack ret = this.drops.get();
        this.drops.remove();
        if (ret != null) {
            drops.add((Object)ret);
        } else {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityDogBed) {
                TileEntityDogBed dogBed = (TileEntityDogBed)tileentity;
                drops.add((Object)DogBedRegistry.createItemStack(dogBed.getCasingId(), dogBed.getBeddingId()));
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TextureAtlasSprite sprite;
        IBlockState state = world.func_180495_p(pos);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleModel && (sprite = ((IStateParticleModel)model).getParticleTexture(state = this.getExtendedState(state.func_185899_b((IBlockAccess)world, pos), (IBlockAccess)world, pos))) != null) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        manager.func_78873_a((Particle)new ParticleCustomDigging(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, state, pos, sprite));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleModel) {
            BlockPos pos = target.func_178782_a();
            EnumFacing side = target.field_178784_b;
            TextureAtlasSprite sprite = ((IStateParticleModel)model).getParticleTexture(state = this.getExtendedState(state.func_185899_b((IBlockAccess)world, pos), (IBlockAccess)world, pos));
            if (sprite != null) {
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
                double d0 = (double)x + RANDOM.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
                double d1 = (double)y + RANDOM.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
                double d2 = (double)z + RANDOM.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
                if (side == EnumFacing.DOWN) {
                    d1 = (double)y + axisalignedbb.field_72338_b - (double)0.1f;
                }
                if (side == EnumFacing.UP) {
                    d1 = (double)y + axisalignedbb.field_72337_e + (double)0.1f;
                }
                if (side == EnumFacing.NORTH) {
                    d2 = (double)z + axisalignedbb.field_72339_c - (double)0.1f;
                }
                if (side == EnumFacing.SOUTH) {
                    d2 = (double)z + axisalignedbb.field_72334_f + (double)0.1f;
                }
                if (side == EnumFacing.WEST) {
                    d0 = (double)x + axisalignedbb.field_72340_a - (double)0.1f;
                }
                if (side == EnumFacing.EAST) {
                    d0 = (double)x + axisalignedbb.field_72336_d + (double)0.1f;
                }
                Particle particle = new ParticleCustomDigging(world, d0, d1, d2, 0.0, 0.0, 0.0, state, pos, sprite).func_70543_e(0.2f).func_70541_f(0.6f);
                manager.func_78873_a(particle);
                return true;
            }
        }
        return false;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState stateAgain, EntityLivingBase entity, int numberOfParticles) {
        CustomParticleMessage packet = new CustomParticleMessage((World)world, pos, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.15f);
        PacketDispatcher.sendToAllAround(packet, world.field_73011_w.getDimension(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 32.0);
        return true;
    }
}

