/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.common;

import com.google.common.collect.Lists;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;
import pl.asie.foamfix.util.HashingStrategies;

public class PropertyValueMapper {
    private static final Comparator<? super IProperty<?>> COMPARATOR_BIT_FITNESS = (first, second) -> {
        int diff2;
        int diff1 = PropertyValueMapper.getPropertyEntry(first).bitSize - first.func_177700_c().size();
        if (diff1 == (diff2 = PropertyValueMapper.getPropertyEntry(second).bitSize - second.func_177700_c().size())) {
            return first.func_177701_a().compareTo(second.func_177701_a());
        }
        return diff1 - diff2;
    };
    private static final Map<IProperty, Entry> entryMap = new IdentityHashMap<IProperty, Entry>();
    private static final Map<BlockStateContainer, PropertyValueMapper> mapperMap = new IdentityHashMap<BlockStateContainer, PropertyValueMapper>();
    private final Entry[] entryList;
    private final TObjectIntMap<String> entryPositionMap;
    private final IBlockState[] stateMap;

    public PropertyValueMapper(BlockStateContainer container) {
        Collection properties = container.func_177623_d();
        this.entryList = new Entry[properties.size()];
        ArrayList propertiesSortedFitness = Lists.newArrayList((Iterable)properties);
        propertiesSortedFitness.sort(COMPARATOR_BIT_FITNESS);
        int i = 0;
        for (IProperty p : propertiesSortedFitness) {
            this.entryList[i++] = PropertyValueMapper.getPropertyEntry(p);
        }
        this.entryPositionMap = new TObjectIntHashMap(10, 0.5f, -1);
        int bitPos = 0;
        Entry lastEntry = null;
        for (Entry ee : this.entryList) {
            this.entryPositionMap.put((Object)ee.property.func_177701_a(), bitPos);
            bitPos += ee.bits;
            lastEntry = ee;
        }
        this.stateMap = lastEntry == null ? new IBlockState[1 << bitPos] : new IBlockState[(1 << bitPos - lastEntry.bits) * lastEntry.property.func_177700_c().size()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyValueMapper getOrCreate(BlockStateContainer owner) {
        Map<BlockStateContainer, PropertyValueMapper> map = mapperMap;
        synchronized (map) {
            return mapperMap.computeIfAbsent(owner, PropertyValueMapper::new);
        }
    }

    protected static Entry getPropertyEntry(IProperty property) {
        Entry e = entryMap.get(property);
        if (e == null) {
            Class<?> propertyClass = property.getClass();
            e = propertyClass == PropertyInteger.class ? IntegerEntry.create((PropertyInteger)property) : (propertyClass == PropertyBool.class && property.func_177700_c().size() == 2 ? new BooleanEntry(property) : (propertyClass == PropertyEnum.class || propertyClass == PropertyDirection.class ? EnumEntrySorted.create((PropertyEnum)property) : new ObjectEntry(property, false)));
            entryMap.put(property, e);
        }
        return e;
    }

    protected int generateValue(IBlockState state) {
        int bitPos = 0;
        int value = 0;
        for (Entry e : this.entryList) {
            value |= e.get(state.func_177229_b(e.property)) << bitPos;
            bitPos += e.bits;
        }
        this.stateMap[value] = state;
        return value;
    }

    public <T extends Comparable<T>, V extends T> IBlockState withProperty(int value, IProperty<T> property, V propertyValue) {
        int bitPos = this.entryPositionMap.get((Object)property.func_177701_a());
        if (bitPos >= 0) {
            Entry e = PropertyValueMapper.getPropertyEntry(property);
            int nv = e.get(propertyValue);
            if (nv < 0) {
                return null;
            }
            int bitMask = e.bitSize - 1;
            value = value & ~(bitMask << bitPos) | nv << bitPos;
            return this.stateMap[value];
        }
        return null;
    }

    public IBlockState getPropertyByValue(int value) {
        return this.stateMap[value];
    }

    public <T extends Comparable<T>, V extends T> int withPropertyValue(int value, IProperty<T> property, V propertyValue) {
        int bitPos = this.entryPositionMap.get((Object)property.func_177701_a());
        if (bitPos >= 0) {
            Entry e = PropertyValueMapper.getPropertyEntry(property);
            int nv = e.get(propertyValue);
            if (nv < 0) {
                return -1;
            }
            int bitMask = e.bitSize - 1;
            value = value & ~(bitMask << bitPos) | nv << bitPos;
            return value;
        }
        return -1;
    }

    public static class IntegerEntry
    extends Entry {
        private Int2IntMap values = new Int2IntOpenHashMap();

        private IntegerEntry(IProperty property) {
            super(property);
            this.values.defaultReturnValue(-1);
            Collection allowedValues = property.func_177700_c();
            int i = 0;
            for (Object o : allowedValues) {
                this.values.put(((Integer)o).intValue(), i++);
            }
        }

        @Override
        public int get(Object v) {
            return this.values.get(((Integer)v).intValue());
        }

        public static Entry create(PropertyInteger entry) {
            ArrayList sorted = Lists.newArrayList((Iterable)entry.func_177700_c());
            sorted.sort(Comparator.naturalOrder());
            int min = (Integer)sorted.get(0);
            for (int i = 1; i < sorted.size(); ++i) {
                if ((Integer)sorted.get(i) - (Integer)sorted.get(i - 1) == 1) continue;
                return new IntegerEntry((IProperty)entry);
            }
            return new IntegerEntrySorted((IProperty)entry, min, sorted.size());
        }
    }

    public static class IntegerEntrySorted
    extends Entry {
        private final int minValue;
        private final int count;

        private IntegerEntrySorted(IProperty property, int minValue, int count) {
            super(property);
            this.minValue = minValue;
            this.count = count;
        }

        @Override
        public int get(Object v) {
            int vv = (Integer)v - this.minValue;
            return vv < this.count ? vv : -1;
        }
    }

    public static class EnumEntrySorted
    extends Entry {
        private EnumEntrySorted(IProperty property, int count) {
            super(property);
        }

        @Override
        public int get(Object v) {
            return ((Enum)v).ordinal();
        }

        public static Entry create(PropertyEnum entry) {
            T[] values = entry.func_177699_b().getEnumConstants();
            if (entry.func_177700_c().size() == values.length) {
                return new EnumEntrySorted((IProperty)entry, values.length);
            }
            return new ObjectEntry((IProperty)entry, true);
        }
    }

    public static class ObjectEntry
    extends Entry {
        private Object2IntMap values;

        private ObjectEntry(IProperty property, boolean identity) {
            super(property);
            this.values = identity ? new Object2IntOpenCustomHashMap(HashingStrategies.FASTUTIL_IDENTITY) : new Object2IntOpenHashMap();
            this.values.defaultReturnValue(-1);
            Collection allowedValues = property.func_177700_c();
            int i = 0;
            for (Object o : allowedValues) {
                this.values.put(o, i++);
            }
        }

        @Override
        public int get(Object v) {
            return this.values.getInt(v);
        }
    }

    public static class BooleanEntry
    extends Entry {
        private BooleanEntry(IProperty property) {
            super(property);
        }

        @Override
        public int get(Object v) {
            return v == Boolean.TRUE ? 1 : 0;
        }
    }

    public static abstract class Entry {
        private final IProperty property;
        private final int bitSize;
        private final int bits;

        private Entry(IProperty property) {
            this.property = property;
            this.bitSize = MathHelper.func_151236_b((int)property.func_177700_c().size());
            int bits = 0;
            for (int b = this.bitSize - 1; b != 0; b >>= 1) {
                ++bits;
            }
            this.bits = bits;
        }

        public abstract int get(Object var1);

        public boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            return ((Entry)other).property.equals(this.property);
        }

        public int hashCode() {
            return this.property.hashCode();
        }
    }
}

