/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleItemRightClickEvent
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.ITEMSTACK.getName()};
    }

    @Override
    public String getModuleName() {
        return "itemRightClickEvent";
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        String methodDesc;
        String methodName;
        ClassNode classNode = ASMHelper.readClassFromBytes(bytes);
        MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.USEITEMRIGHTCLICK.getName(), methodDesc = ObfNameHelper.Methods.USEITEMRIGHTCLICK.getDescriptor());
        if (method != null) {
            ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
            if (this.redirectUseItemRightClick(method, transformedName)) {
                ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                return ASMHelper.writeClassToBytes(classNode);
            }
        } else {
            ASMDebugHelper.logNotFound(methodName, transformedName);
        }
        return bytes;
    }

    private boolean redirectUseItemRightClick(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.find(method.instructions, (AbstractInsnNode)ObfNameHelper.Methods.ONITEMRIGHTCLICK.toInsnNode(182));
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        MethodInsnNode replacement = ObfNameHelper.Methods.ONUSEITEMRIGHTCLICK.toInsnNode(184);
        method.instructions.set(target, (AbstractInsnNode)replacement);
        return true;
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }
}

