/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonTime;

public class SeasonASMHelper {
    public static boolean canSnowAtInSeason(World world, BlockPos pos, boolean checkLight, @Nullable ISeasonState seasonState) {
        return SeasonASMHelper.canSnowAtInSeason(world, pos, checkLight, seasonState, false);
    }

    public static boolean canSnowAtInSeason(World world, BlockPos pos, boolean checkLight, @Nullable ISeasonState seasonState, boolean useUnmodifiedTemperature) {
        Biome biome = world.func_180494_b(pos);
        float temperature = biome.func_180626_a(pos);
        if (BiomeConfig.enablesSeasonalEffects(biome) && !useUnmodifiedTemperature && SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.getDimension())) {
            if (BiomeConfig.usesTropicalSeasons(biome)) {
                return false;
            }
            temperature = SeasonASMHelper.getFloatTemperature(world, biome, pos);
        }
        if (temperature >= 0.15f) {
            return false;
        }
        if (biome.func_185353_n() >= 0.15f && !ModConfig.seasons.generateSnowAndIce) {
            return false;
        }
        if (checkLight) {
            IBlockState state;
            return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && (state = world.func_180495_p(pos)).func_177230_c().isAir(state, (IBlockAccess)world, pos) && Blocks.field_150431_aC.func_176196_c(world, pos);
        }
        return true;
    }

    public static boolean canBlockFreezeInSeason(World world, BlockPos pos, boolean noWaterAdj, @Nullable ISeasonState seasonState) {
        return SeasonASMHelper.canBlockFreezeInSeason(world, pos, noWaterAdj, seasonState, false);
    }

    public static boolean canBlockFreezeInSeason(World world, BlockPos pos, boolean noWaterAdj, @Nullable ISeasonState seasonState, boolean useUnmodifiedTemperature) {
        IBlockState iblockstate;
        Block block;
        Biome biome = world.func_180494_b(pos);
        float temperature = biome.func_180626_a(pos);
        if (BiomeConfig.enablesSeasonalEffects(biome) && !useUnmodifiedTemperature && SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.getDimension())) {
            if (BiomeConfig.usesTropicalSeasons(biome)) {
                return false;
            }
            temperature = SeasonASMHelper.getFloatTemperature(world, biome, pos);
        }
        if (temperature >= 0.15f) {
            return false;
        }
        if (biome.func_185353_n() >= 0.15f && !ModConfig.seasons.generateSnowAndIce) {
            return false;
        }
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && ((block = (iblockstate = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i) && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            boolean flag;
            if (!noWaterAdj) {
                return true;
            }
            boolean bl = flag = world.func_175696_F(pos.func_177976_e()) && world.func_175696_F(pos.func_177974_f()) && world.func_175696_F(pos.func_177978_c()) && world.func_175696_F(pos.func_177968_d());
            if (!flag) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRainingAtInSeason(World world, BlockPos pos, ISeasonState seasonState) {
        Biome biome = world.func_180494_b(pos);
        if (BiomeConfig.usesTropicalSeasons(biome) && BiomeConfig.enablesSeasonalEffects(biome) && SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.getDimension())) {
            Season.TropicalSeason tropicalSeason = seasonState.getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
            return biome.func_76738_d();
        }
        if (biome.func_76746_c() || world.func_175708_f(pos, false)) {
            return false;
        }
        return biome.func_76738_d();
    }

    public static float getFloatTemperature(World world, Biome biome, BlockPos pos) {
        if (!SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.getDimension())) {
            return biome.func_180626_a(pos);
        }
        return SeasonASMHelper.getFloatTemperature(new SeasonTime(SeasonHelper.getSeasonState(world).getSeasonCycleTicks()).getSubSeason(), biome, pos);
    }

    public static float getFloatTemperature(Season.SubSeason subSeason, Biome biome, BlockPos pos) {
        boolean tropicalBiome = BiomeConfig.usesTropicalSeasons(biome);
        float biomeTemp = biome.func_180626_a(pos);
        if (!tropicalBiome && biome.func_185353_n() <= 0.8f && BiomeConfig.enablesSeasonalEffects(biome)) {
            switch (subSeason) {
                default: {
                    break;
                }
                case LATE_SPRING: 
                case EARLY_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.1f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case MID_SPRING: 
                case MID_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.2f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_SPRING: 
                case LATE_AUTUMN: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.4f), (float)-0.5f, (float)2.0f);
                    break;
                }
                case EARLY_WINTER: 
                case MID_WINTER: 
                case LATE_WINTER: {
                    biomeTemp = MathHelper.func_76131_a((float)(biomeTemp - 0.8f), (float)-0.5f, (float)2.0f);
                }
            }
        }
        return biomeTemp;
    }

    public static boolean shouldRenderRainSnow(World world, Biome biome) {
        if (BiomeConfig.usesTropicalSeasons(biome) && BiomeConfig.enablesSeasonalEffects(biome) && SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.getDimension())) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(world).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
            return biome.func_76738_d() || biome.func_76746_c();
        }
        return biome.func_76738_d() || biome.func_76746_c();
    }

    public static boolean shouldAddRainParticles(World world, Biome biome) {
        if (BiomeConfig.usesTropicalSeasons(biome) && BiomeConfig.enablesSeasonalEffects(biome) && SeasonsConfig.isDimensionWhitelisted(world.field_73011_w.getDimension())) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(world).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
            return biome.func_76738_d();
        }
        return biome.func_76738_d();
    }
}

