/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.datastructures;

import java.util.PriorityQueue;
import java.util.function.Predicate;

public class ExplicitPriorityQueue<T> {
    private PriorityQueue<Entry> queue;

    public ExplicitPriorityQueue(int initialSize) {
        this.queue = new PriorityQueue(Math.max(1, initialSize));
    }

    public ExplicitPriorityQueue() {
        this(11);
    }

    public void add(T object, double priority) {
        this.queue.add(new Entry<T>(object, priority));
    }

    public void removeIf(Predicate<Entry> predicate) {
        this.queue.removeIf(predicate);
    }

    public T peek() {
        Entry result = this.queue.peek();
        return result == null ? null : (T)result.object;
    }

    public double peekPriority() {
        Entry result = this.queue.peek();
        return result == null ? Double.NaN : result.priority;
    }

    public T poll() {
        Entry result = this.queue.poll();
        return result == null ? null : (T)result.object;
    }

    public T[] toArray() {
        Object[] result = new Object[this.queue.size()];
        Object[] array = this.queue.toArray();
        for (int i = 0; i < this.queue.size(); ++i) {
            result[i] = ((Entry)array[i]).object;
        }
        return result;
    }

    public void clear() {
        this.queue.clear();
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public ExplicitPriorityQueue<T> clone() {
        Entry[] array;
        ExplicitPriorityQueue<T> clone = new ExplicitPriorityQueue<T>(this.size());
        for (Entry entry : array = this.queue.toArray(new Entry[this.size()])) {
            super.add(entry);
        }
        return clone;
    }

    private void add(Entry<T> entry) {
        this.queue.add(entry);
    }

    public class Entry<A>
    implements Comparable<Entry> {
        public A object;
        public double priority;

        Entry(A object, double priority) {
            this.object = object;
            this.priority = priority;
        }

        @Override
        public int compareTo(Entry o) {
            return Double.compare(this.priority, o.priority);
        }
    }
}

