/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.datastructures;

import com.fantasticsource.tools.Tools;

public class Color {
    public static final Color BLANK = new Color(0);
    public static final Color BLACK = new Color(255);
    public static final Color WHITE = new Color(-1);
    public static final Color RED = new Color(-16776961);
    public static final Color GREEN = new Color(0xFF00FF);
    public static final Color BLUE = new Color(65535);
    public static final Color YELLOW = new Color(-65281);
    public static final Color AQUA = new Color(0xFFFFFF);
    public static final Color PURPLE = new Color(-16711681);
    public static final Color GRAY = new Color(0x777777FF);
    public static final Color ORANGE = new Color(-8978177);
    private int intValue;
    private int r;
    private int g;
    private int b;
    private int a;
    private float rf;
    private float gf;
    private float bf;
    private float af;
    private String hex;

    public Color(int color) {
        this.setColor(color);
    }

    public Color(int color, boolean noAlpha) {
        if (noAlpha) {
            this.setColorNoAlpha(color);
        } else {
            this.setColor(color);
        }
    }

    public Color(int r, int g, int b, int a) {
        this.setColor(r, g, b, a);
    }

    public Color(int r, int g, int b) {
        this.setColor(r, g, b);
    }

    public Color(float r, float g, float b, float a) {
        this.setColor(r, g, b, a);
    }

    public Color(float r, float g, float b) {
        this.setColor(r, g, b);
    }

    public Color(String hex) {
        this.setColor(hex);
    }

    public Color(String hex, boolean noAlpha) {
        if (noAlpha) {
            this.setColorNoAlpha(hex);
        } else {
            this.setColor(hex);
        }
    }

    public Color copy() {
        return new Color(this.intValue);
    }

    public Color setR(int r) {
        this.r = r;
        this.rf = (float)r / 255.0f;
        this.intValue = r << 24 | this.g << 16 | this.b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setRF(float rf) {
        this.rf = rf;
        this.r = (int)(rf * 255.0f);
        this.intValue = this.r << 24 | this.g << 16 | this.b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setG(int g) {
        this.g = g;
        this.gf = (float)g / 255.0f;
        this.intValue = this.r << 24 | g << 16 | this.b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setGF(float gf) {
        this.gf = gf;
        this.g = (int)(gf * 255.0f);
        this.intValue = this.r << 24 | this.g << 16 | this.b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setB(int b) {
        this.b = b;
        this.bf = (float)b / 255.0f;
        this.intValue = this.r << 24 | this.g << 16 | b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setBF(float bf) {
        this.bf = bf;
        this.b = (int)(bf * 255.0f);
        this.intValue = this.r << 24 | this.g << 16 | this.b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setA(int a) {
        this.a = a;
        this.af = (float)a / 255.0f;
        this.intValue = this.r << 24 | this.g << 16 | this.b << 8 | a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setAF(float af) {
        this.af = af;
        this.a = (int)(af * 255.0f);
        this.intValue = this.r << 24 | this.g << 16 | this.b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setColor(int color) {
        this.intValue = color;
        this.r = this.intValue >> 24 & 0xFF;
        this.g = this.intValue >> 16 & 0xFF;
        this.b = this.intValue >> 8 & 0xFF;
        this.a = this.intValue & 0xFF;
        this.rf = (float)this.r / 255.0f;
        this.gf = (float)this.g / 255.0f;
        this.bf = (float)this.b / 255.0f;
        this.af = (float)this.a / 255.0f;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setColorNoAlpha(int color) {
        return this.setColor(color << 8 | 0xFF);
    }

    public Color setColor(int r, int g, int b, int a) {
        this.r = Tools.min(Tools.max(r, 0), 255);
        this.g = Tools.min(Tools.max(g, 0), 255);
        this.b = Tools.min(Tools.max(b, 0), 255);
        this.a = Tools.min(Tools.max(a, 0), 255);
        this.rf = (float)r / 255.0f;
        this.gf = (float)g / 255.0f;
        this.bf = (float)b / 255.0f;
        this.af = (float)a / 255.0f;
        this.intValue = r << 24 | g << 16 | b << 8 | a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setColor(int r, int g, int b) {
        return this.setColor(r, g, b, 255);
    }

    public Color setColor(float r, float g, float b, float a) {
        this.rf = Tools.min(Tools.max(r, 0.0f), 1.0f);
        this.gf = Tools.min(Tools.max(g, 0.0f), 1.0f);
        this.bf = Tools.min(Tools.max(b, 0.0f), 1.0f);
        this.af = Tools.min(Tools.max(a, 0.0f), 1.0f);
        this.r = Tools.min(Tools.max((int)(this.rf * 255.0f), 0), 255);
        this.g = Tools.min(Tools.max((int)(this.gf * 255.0f), 0), 255);
        this.b = Tools.min(Tools.max((int)(this.bf * 255.0f), 0), 255);
        this.a = Tools.min(Tools.max((int)(this.af * 255.0f), 0), 255);
        this.intValue = this.r << 24 | this.g << 16 | this.b << 8 | this.a;
        this.hex = Integer.toHexString(this.intValue);
        return this;
    }

    public Color setColor(float r, float g, float b) {
        return this.setColor(r, g, b, 1.0f);
    }

    public Color setColor(String hex) {
        this.hex = hex;
        this.intValue = Tools.parseHexInt(hex);
        this.r = this.intValue >> 24 & 0xFF;
        this.g = this.intValue >> 16 & 0xFF;
        this.b = this.intValue >> 8 & 0xFF;
        this.a = this.intValue & 0xFF;
        this.rf = (float)this.r / 255.0f;
        this.gf = (float)this.g / 255.0f;
        this.bf = (float)this.b / 255.0f;
        this.af = (float)this.a / 255.0f;
        return this;
    }

    public Color setColorNoAlpha(String hex) {
        return this.setColor(hex + "ff");
    }

    public int color() {
        return this.intValue;
    }

    public int toARGB() {
        return this.intValue >> 8 | this.a << 24;
    }

    public int r() {
        return this.r;
    }

    public int g() {
        return this.g;
    }

    public int b() {
        return this.b;
    }

    public int a() {
        return this.a;
    }

    public float rf() {
        return this.rf;
    }

    public float gf() {
        return this.gf;
    }

    public float bf() {
        return this.bf;
    }

    public float af() {
        return this.af;
    }

    public String hex() {
        return this.hex;
    }

    public String hex8() {
        StringBuilder result = new StringBuilder();
        for (int i = this.hex.length(); i < 8; ++i) {
            result.append("0");
        }
        return result + this.hex;
    }

    public String toString() {
        return this.hex();
    }

    public int v() {
        return (int)((double)(this.r + this.g + this.b) / 3.0);
    }

    public float vf() {
        return (this.rf + this.gf + this.bf) / 3.0f;
    }

    public Color setV(int v) {
        if ((v &= 0xFF) == 0) {
            this.setColor(0, 0, 0, this.a);
        } else if (v == 255) {
            this.setColor(255, 255, 255, this.a);
        } else {
            int current = this.v();
            int rr = (int)((double)v / (double)current * (double)this.r);
            int gg = (int)((double)v / (double)current * (double)this.g);
            int bb = (int)((double)v / (double)current * (double)this.b);
            if (rr >= 255) {
                if (gg >= 255) {
                    bb = Tools.min(255, rr + gg + bb - 510);
                    rr = 255;
                    gg = 255;
                } else if (bb >= 255) {
                    gg = Tools.min(255, rr + gg + bb - 510);
                    rr = 255;
                    bb = 255;
                } else {
                    int overflow = rr - 255;
                    rr = 255;
                    if (gg > bb) {
                        double ratio;
                        int inc;
                        if ((gg += (inc = (int)((ratio = (double)gg / (double)(bb + gg)) * (double)overflow))) > 255) {
                            overflow += gg - 255;
                            gg = 255;
                        }
                        bb = Tools.min(255, bb + overflow - inc);
                    } else {
                        double ratio;
                        int inc;
                        if ((bb += (inc = (int)((ratio = gg + bb == 0 ? 0.5 : (double)bb / (double)(bb + gg)) * (double)overflow))) > 255) {
                            overflow += bb - 255;
                            bb = 255;
                        }
                        gg = Tools.min(255, gg + overflow - inc);
                    }
                }
            } else if (gg >= 255) {
                if (bb >= 255) {
                    rr = Tools.min(255, rr + gg + bb - 510);
                    gg = 255;
                    bb = 255;
                } else {
                    int overflow = gg - 255;
                    gg = 255;
                    if (rr > bb) {
                        double ratio;
                        int inc;
                        if ((rr += (inc = (int)((ratio = (double)rr / (double)(bb + rr)) * (double)overflow))) > 255) {
                            overflow += rr - 255;
                            rr = 255;
                        }
                        bb = Tools.min(255, bb + overflow - inc);
                    } else {
                        double ratio;
                        int inc;
                        if ((bb += (inc = (int)((ratio = rr + bb == 0 ? 0.5 : (double)bb / (double)(bb + rr)) * (double)overflow))) > 255) {
                            overflow += bb - 255;
                            bb = 255;
                        }
                        rr = Tools.min(255, rr + overflow - inc);
                    }
                }
            } else if (bb >= 255) {
                int overflow = bb - 255;
                bb = 255;
                if (rr > gg) {
                    double ratio;
                    int inc;
                    if ((rr += (inc = (int)((ratio = (double)rr / (double)(gg + rr)) * (double)overflow))) > 255) {
                        overflow += rr - 255;
                        rr = 255;
                    }
                    gg = Tools.min(255, gg + overflow - inc);
                } else {
                    double ratio;
                    int inc;
                    if ((gg += (inc = (int)((ratio = gg + rr == 0 ? 0.5 : (double)gg / (double)(gg + rr)) * (double)overflow))) > 255) {
                        overflow += gg - 255;
                        gg = 255;
                    }
                    rr = Tools.min(255, rr + overflow - inc);
                }
            }
            this.setR(rr);
            this.setG(gg);
            this.setB(bb);
        }
        return this;
    }

    public Color setVF(float vf) {
        return this.setV((int)(vf * 255.0f));
    }

    public boolean equals(Object obj) {
        return obj instanceof Color && ((Color)obj).intValue == this.intValue;
    }
}

