/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import sun.misc.Cleaner;

public class Tools {
    public static String fixFileSeparators(String input) {
        return input.replaceAll("[/\\\\]", Matcher.quoteReplacement(File.separator));
    }

    public static ByteBuffer cloneByteBuffer(ByteBuffer original) {
        int pos = original.position();
        int limit = original.limit();
        int mark = -1;
        try {
            original.reset();
            mark = original.position();
        }
        catch (InvalidMarkException invalidMarkException) {
            // empty catch block
        }
        ByteBuffer clone = original.isDirect() ? ByteBuffer.allocateDirect(original.capacity()) : ByteBuffer.allocate(original.capacity());
        clone.order(original.order());
        original.limit(original.capacity());
        original.position(0);
        clone.put(original);
        if (mark != -1) {
            original.position(mark);
            original.mark();
            clone.position(mark);
            clone.mark();
        }
        original.position(pos);
        original.limit(limit);
        clone.position(pos);
        clone.limit(limit);
        return clone;
    }

    public static String[] sort(String ... values) {
        String[] result = new String[values.length];
        System.arraycopy(values, 0, result, 0, result.length);
        for (int passesRemaining = result.length - 1; passesRemaining > 0; --passesRemaining) {
            for (int i = 0; i < passesRemaining; ++i) {
                if (Tools.inOrder(result[i], result[i + 1])) continue;
                String s = result[i];
                result[i] = result[i + 1];
                result[i + 1] = s;
            }
        }
        return result;
    }

    public static boolean inOrder(String s1, String s2) {
        char[] chars1 = s1.toLowerCase().toCharArray();
        char[] chars2 = s2.toLowerCase().toCharArray();
        for (int i = 0; i < chars1.length; ++i) {
            if (i >= chars2.length || chars2[i] < chars1[i]) {
                return false;
            }
            if (chars1[i] >= chars2[i]) continue;
            return true;
        }
        return true;
    }

    public static int parseHexInt(String hex) {
        if ((hex = hex.replaceAll("0x", "")).length() > 8) {
            throw new NumberFormatException("Hex string too long (max 8 characters): " + hex);
        }
        if (hex.length() < 8) {
            return Integer.parseInt(hex, 16);
        }
        return Integer.parseInt(hex.substring(0, 2), 16) << 24 | Integer.parseInt(hex.substring(2), 16);
    }

    public static boolean isPowerOfTwo(int n) {
        if (n == 0) {
            return false;
        }
        while (n != 1) {
            if (n % 2 != 0) {
                return false;
            }
            n >>= 1;
        }
        return true;
    }

    public static ArrayList<String> allRecursiveRelativeFilenames(String directory) {
        File folder = new File(directory);
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IllegalStateException("Directory does not exist: " + directory);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : folder.listFiles()) {
            if (!file.isDirectory()) {
                result.add(file.getName());
                continue;
            }
            result.addAll(Tools.allRecursiveRelativeFilenames(directory, file.getName()));
        }
        return result;
    }

    private static ArrayList<String> allRecursiveRelativeFilenames(String mainDirectory, String relativeSubDirectory) {
        String fullDirectory = mainDirectory + File.separator + relativeSubDirectory;
        File folder = new File(fullDirectory);
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IllegalStateException("Directory does not exist: " + fullDirectory);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (File file : folder.listFiles()) {
            if (!file.isDirectory()) {
                result.add(relativeSubDirectory + File.separator + file.getName());
                continue;
            }
            result.addAll(Tools.allRecursiveRelativeFilenames(fullDirectory, file.getName()));
        }
        return result;
    }

    public static boolean deleteFilesRecursively(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                Tools.deleteFilesRecursively(f);
            }
        }
        return file.delete();
    }

    public static String[] fixedSplit(String string, String regex) {
        if (string == null) {
            return null;
        }
        if (regex == null) {
            return new String[]{string};
        }
        return Tools.preservedSplitSeparated(string, regex)[0];
    }

    public static String[] preservedSplit(String string, String regex, boolean interpolateResult) {
        if (string == null) {
            return null;
        }
        if (regex == null) {
            return new String[]{string};
        }
        String[][] separated = Tools.preservedSplitSeparated(string, regex);
        String[] tokens = separated[0];
        String[] delimiters = separated[1];
        String[] result = new String[tokens.length + delimiters.length];
        if (interpolateResult) {
            int delimiterCount = delimiters.length;
            for (int i = 0; i < delimiterCount; ++i) {
                result[i << 1] = tokens[i];
                result[(i << 1) + 1] = delimiters[i];
            }
            result[result.length - 1] = tokens[tokens.length - 1];
        } else {
            System.arraycopy(tokens, 0, result, 0, tokens.length);
            System.arraycopy(delimiters, 0, result, tokens.length, delimiters.length);
        }
        return result;
    }

    public static String[][] preservedSplitSeparated(String string, String regex) {
        if (string == null) {
            return null;
        }
        if (regex == null) {
            return new String[][]{{string}, new String[0]};
        }
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> delimiters = new ArrayList<String>();
        String prev = string;
        String current = string.replaceFirst(regex, "");
        while (!prev.equals(current)) {
            int lengthDif = prev.length() - current.length();
            int prevIndex = prev.length() - 1;
            for (int curIndex = current.length() - 1; curIndex >= 0 && prev.charAt(prevIndex) == current.charAt(curIndex); --curIndex) {
                --prevIndex;
            }
            int startIndex = prevIndex + 1 - lengthDif;
            tokens.add(prev.substring(0, startIndex));
            delimiters.add(prev.substring(startIndex, startIndex + lengthDif));
            prev = prev.substring(startIndex + lengthDif);
            current = prev.replaceFirst(regex, "");
        }
        tokens.add(current);
        return new String[][]{tokens.toArray(new String[0]), delimiters.toArray(new String[0])};
    }

    public static int angleDifDeg(int angle1, int angle2) {
        return Tools.posMod(angle2 - angle1, 360);
    }

    public static float angleDifDeg(float angle1, float angle2) {
        return Tools.posMod(angle2 - angle1, 360.0f);
    }

    public static double angleDifDeg(double angle1, double angle2) {
        return Tools.posMod(angle2 - angle1, 360.0);
    }

    public static float angleDifRad(float angle1, float angle2) {
        return Tools.posMod(angle2 - angle1, (float)Math.PI * 2);
    }

    public static double angleDifRad(double angle1, double angle2) {
        return Tools.posMod(angle2 - angle1, Math.PI * 2);
    }

    public static int average(int ... values) {
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        return sum / values.length;
    }

    public static float average(float ... values) {
        float sum = 0.0f;
        for (float value : values) {
            sum += value;
        }
        return sum / (float)values.length;
    }

    public static double average(double ... values) {
        double sum = 0.0;
        for (double value : values) {
            sum += value;
        }
        return sum / (double)values.length;
    }

    public static int min(int ... values) {
        int result = Integer.MAX_VALUE;
        for (int value : values) {
            if (value >= result) continue;
            result = value;
        }
        return result;
    }

    public static float min(float ... values) {
        float result = Float.POSITIVE_INFINITY;
        for (float value : values) {
            if (!(value < result)) continue;
            result = value;
        }
        return result;
    }

    public static double min(double ... values) {
        double result = Double.POSITIVE_INFINITY;
        for (double value : values) {
            if (!(value < result)) continue;
            result = value;
        }
        return result;
    }

    public static int max(int ... values) {
        int result = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= result) continue;
            result = value;
        }
        return result;
    }

    public static float max(float ... values) {
        float result = Float.NEGATIVE_INFINITY;
        for (float value : values) {
            if (!(value > result)) continue;
            result = value;
        }
        return result;
    }

    public static double max(double ... values) {
        double result = Double.NEGATIVE_INFINITY;
        for (double value : values) {
            if (!(value > result)) continue;
            result = value;
        }
        return result;
    }

    public static void printStackTrace(Thread thread, int maxNodes) {
        StackTraceElement[] stack = thread.getStackTrace();
        for (int i = 0; i < maxNodes && i < stack.length; ++i) {
            System.out.println(stack[i].toString());
        }
    }

    public static void printStackTrace(Thread thread) {
        Tools.printStackTrace(thread, Integer.MAX_VALUE);
    }

    public static void printStackTrace() {
        Tools.printStackTrace(Thread.currentThread());
    }

    public static boolean stackContainsSubstring(Thread thread, String subString) {
        StackTraceElement[] stack;
        subString = subString.toLowerCase();
        for (StackTraceElement element : stack = thread.getStackTrace()) {
            if (!element.getClassName().toLowerCase().contains(subString)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackContainsSubstring(String substring) {
        return Tools.stackContainsSubstring(Thread.currentThread(), substring);
    }

    public static List<Class> getClassTree(Class clss) {
        if (clss == null) {
            return null;
        }
        ArrayList<Class> classList = new ArrayList<Class>();
        while (clss != null) {
            classList.add(clss);
            clss = clss.getSuperclass();
        }
        return classList;
    }

    public static void printClassTree(Class clss) {
        if (clss == null) {
            System.out.println("Class given was null");
        } else {
            System.out.println("===================================");
            System.out.println(clss.getSimpleName() + " Classtree:");
            while (clss != null) {
                System.out.println(clss.getName());
                clss = clss.getSuperclass();
            }
            System.out.println("===================================");
        }
    }

    public static void printMethods(Class clss) {
        if (clss == null) {
            System.out.println("Class given was null");
        } else {
            System.out.println("===================================");
            System.out.println(clss.getSimpleName() + " Methods:");
            for (Method method : clss.getDeclaredMethods()) {
                System.out.println(method);
            }
            System.out.println("===================================");
        }
    }

    public static void printFields(Class clss) {
        if (clss == null) {
            System.out.println("Class given was null");
        } else {
            System.out.println("===================================");
            System.out.println(clss.getSimpleName() + " Fields:");
            for (Field field : clss.getDeclaredFields()) {
                System.out.println(field);
            }
            System.out.println("===================================");
        }
    }

    public static <T> T choose(T[] choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static <T> T choose(List<T> choices) {
        return choices.get((int)Math.floor(Math.random() * (double)choices.size()));
    }

    public static byte choose(byte ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static short choose(short ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static int choose(int ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static long choose(long ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static float choose(float ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static double choose(double ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static boolean choose(boolean ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static char choose(char ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static String choose(String ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static <E> E chooseObj(E ... choices) {
        return choices[(int)Math.floor(Math.random() * (double)choices.length)];
    }

    public static void insertBytes(byte[] bytes, int index, short value) {
        bytes[index] = (byte)(value >> 8);
        bytes[index + 1] = (byte)value;
    }

    public static void insertBytes(byte[] bytes, int index, char value) {
        bytes[index] = (byte)(value >> 8);
        bytes[index + 1] = (byte)value;
    }

    public static void insertBytes(byte[] bytes, int index, int value) {
        bytes[index] = (byte)(value >> 24);
        bytes[index + 1] = (byte)(value >> 16);
        bytes[index + 2] = (byte)(value >> 8);
        bytes[index + 3] = (byte)value;
    }

    public static void insertBytes(byte[] bytes, int index, float value) {
        Tools.insertBytes(bytes, index, Float.floatToRawIntBits(value));
    }

    public static void insertBytes(byte[] bytes, int index, long value) {
        bytes[index] = (byte)(value >> 56);
        bytes[index + 1] = (byte)(value >> 48);
        bytes[index + 2] = (byte)(value >> 40);
        bytes[index + 3] = (byte)(value >> 32);
        bytes[index + 4] = (byte)(value >> 24);
        bytes[index + 5] = (byte)(value >> 16);
        bytes[index + 6] = (byte)(value >> 8);
        bytes[index + 7] = (byte)value;
    }

    public static void insertBytes(byte[] bytes, int index, double value) {
        Tools.insertBytes(bytes, index, Double.doubleToRawLongBits(value));
    }

    public static byte[] mergeByteArrays(byte[] dest, byte[] src) {
        int i;
        byte[] temp = new byte[dest.length + src.length];
        for (i = 0; i < dest.length; ++i) {
            temp[i] = dest[i];
        }
        int i2 = i;
        while (i < temp.length) {
            temp[i] = src[i - i2];
            ++i;
        }
        return temp;
    }

    public static byte[] subArray(byte[] bytes, int start) {
        return Tools.subArray(bytes, start, bytes.length - start);
    }

    public static byte[] subArray(byte[] bytes, int start, int length) {
        byte[] result = new byte[length];
        System.arraycopy(bytes, start, result, 0, length);
        return result;
    }

    public static char[] subArray(char[] chars, int start) {
        return Tools.subArray(chars, start, chars.length - start);
    }

    public static char[] subArray(char[] chars, int start, int length) {
        char[] result = new char[length];
        System.arraycopy(chars, start, result, 0, length);
        return result;
    }

    public static short bytesToShort(byte[] b, int index) {
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public static char bytesToChar(byte[] b, int index) {
        return (char)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public static int bytesToInt(byte[] b, int index) {
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    public static float bytesToFloat(byte[] b, int index) {
        return Float.intBitsToFloat(Tools.bytesToInt(b, index));
    }

    public static String bytesToASCII(byte[] b, int index, int length) {
        String result = "";
        for (int i = 0; i < length; ++i) {
            result = result + (char)b[index + i];
        }
        return result;
    }

    public static double degtorad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double radtodeg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public static int posMod(int a, int b) {
        if ((a %= b) < 0) {
            a += b;
        }
        return a;
    }

    public static float posMod(float a, float b) {
        if ((a %= b) < 0.0f) {
            a += b;
        }
        return a;
    }

    public static double posMod(double a, double b) {
        if ((a %= b) < 0.0) {
            a += b;
        }
        return a;
    }

    public static byte random(byte maxvalue) {
        return (byte)((double)maxvalue * Math.random());
    }

    public static short random(short maxvalue) {
        return (short)((double)maxvalue * Math.random());
    }

    public static int random(int maxvalue) {
        return (int)((double)maxvalue * Math.random());
    }

    public static long random(long maxvalue) {
        return (long)((double)maxvalue * Math.random());
    }

    public static float random(float maxvalue) {
        return (float)((double)maxvalue * Math.random());
    }

    public static double random(double maxvalue) {
        return maxvalue * Math.random();
    }

    public static char random(char maxvalue) {
        return (char)((double)maxvalue * Math.random());
    }

    public static double randomGaussian(Random random, double center, double range) {
        double result = random.nextGaussian() * 0.5;
        while (result < -1.0 || result > 1.0) {
            result = random.nextGaussian() * 0.5;
        }
        return center + range * result;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static void freeDirectByteBuffer(ByteBuffer directBuffer) throws NoSuchFieldException, IllegalAccessException {
        Field field = directBuffer.getClass().getDeclaredField("cleaner");
        field.setAccessible(true);
        Cleaner cleaner = (Cleaner)field.get(directBuffer);
        cleaner.clean();
    }

    public static String readTXT(String filename) throws IOException {
        return Tools.readTXT(filename, false, null);
    }

    public static String readTXT(String filename, boolean internal, Class calledFrom) throws IOException {
        String line;
        InputStream in = internal ? calledFrom.getResourceAsStream(filename) : new FileInputStream(filename);
        String result = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((line = reader.readLine()) != null) {
            result = result + line + "\r\n";
        }
        reader.close();
        in.close();
        return result;
    }

    public static ByteBuffer allocateNative(int bytes) {
        return ByteBuffer.allocateDirect(bytes).order(ByteOrder.nativeOrder());
    }
}

