/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.view;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.other.GUIDarkenedBackground;
import com.fantasticsource.mctools.gui.element.text.GUIText;
import com.fantasticsource.mctools.gui.element.view.GUIAutocroppedView;
import com.fantasticsource.tools.Tools;

public class GUITooltipView
extends GUIAutocroppedView {
    private double offset = 0.0;

    public GUITooltipView(GUIScreen screen) {
        super(screen, 0.0, 0.0, 0.0, new GUIDarkenedBackground(screen));
    }

    @Override
    public void draw() {
        this.x = this.mouseX() + this.offset;
        this.y = this.mouseY() - this.height / 2.0;
        if (this.y + this.height > 1.0) {
            this.y = 1.0 - this.height;
        }
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        if (this.x + this.width > 1.0) {
            this.x = this.mouseX() - this.width - this.offset;
        }
        if (this.x < 0.0) {
            this.x = 1.0 - this.width;
        }
        if (this.x < 0.0) {
            this.x = 0.0;
        }
        this.drawChildren();
    }

    @Override
    public GUITooltipView recalc(int subIndexChanged) {
        this.width = 1.0;
        this.height = 1.0;
        if (this.parent == null) {
            return this;
        }
        this.recalcAndRepositionSubElements(0);
        this.width = 0.0;
        this.height = 0.0;
        for (GUIElement element : this.children) {
            if (element == this.background) continue;
            this.width = Tools.max(this.width, element.x + element.width);
            this.height = Tools.max(this.height, element.y + element.height);
        }
        this.recalcAndRepositionSubElements(0);
        double paddingPx = (double)Tools.min(this.absolutePxWidth(), this.absolutePxHeight()) * this.padding;
        double xPad = paddingPx / (double)this.parent.absolutePxWidth();
        double yPad = paddingPx / (double)this.parent.absolutePxHeight();
        this.width += xPad * 2.0;
        this.height += yPad * 2.0;
        xPad /= this.width;
        yPad /= this.height;
        for (GUIElement element : this.children) {
            if (element == this.background) continue;
            element.x += (0.5 - element.x) * 2.0 * xPad;
            element.y += (0.5 - element.y) * 2.0 * yPad;
        }
        this.offset = 12.0 / (double)this.screen.field_146294_l;
        this.postRecalc();
        return this;
    }

    @Override
    public GUIElement setTooltip(String tooltip) {
        this.clear();
        this.add(this.background);
        for (String line : Tools.fixedSplit(tooltip, "\n")) {
            this.add(new GUIText(this.screen, line));
        }
        return this;
    }
}

