/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.view;

import com.fantasticsource.mctools.gui.GUILeftClickEvent;
import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.other.GUIGradientBorder;
import com.fantasticsource.mctools.gui.element.text.GUITextButton;
import com.fantasticsource.mctools.gui.element.view.GUIView;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GUITabView
extends GUIView {
    public final double scale;
    public ArrayList<GUIElement> tabs = new ArrayList();
    public ArrayList<GUIView> tabViews = new ArrayList();
    private GUIElement tabBackground = null;
    private int current = 0;
    private boolean autocalcTabs = false;
    private boolean autocalcTabviews = false;

    public GUITabView(GUIScreen screen, double width, double height, String ... tabNames) {
        this(screen, width, height, 1.0, tabNames);
    }

    public GUITabView(GUIScreen screen, double width, double height, double scale, String ... tabNames) {
        this(screen, width, height, scale, GUITabView.genTabs(screen, scale, tabNames), new GUIView[0]);
        this.autocalcTabs = true;
        this.autocalcTabviews = true;
        GUITextButton tab = (GUITextButton)this.tabs.get(0);
        this.tabBackground = new GUIGradientBorder(screen, 0.0, 0.0, 1.0, 1.0, 0.1, ((GUIGradientBorder)tab.background).border, ((GUIGradientBorder)tab.background).center);
        this.add(0, this.tabBackground);
        this.recalc(0);
    }

    public GUITabView(GUIScreen screen, double width, double height, String[] tabNames, GUIView ... tabViews) {
        this(screen, width, height, 1.0, tabNames, tabViews);
    }

    public GUITabView(GUIScreen screen, double width, double height, double scale, String[] tabNames, GUIView ... tabViews) {
        this(screen, width, height, scale, GUITabView.genTabs(screen, scale, tabNames), tabViews);
        this.autocalcTabs = true;
        GUITextButton tab = (GUITextButton)this.tabs.get(0);
        this.tabBackground = new GUIGradientBorder(screen, 0.0, 0.0, 1.0, 1.0, 0.1, ((GUIGradientBorder)tab.background).border, ((GUIGradientBorder)tab.background).center);
        this.add(0, this.tabBackground);
        this.recalc(0);
    }

    public GUITabView(GUIScreen screen, double width, double height, GUIElement[] tabs, GUIView ... tabViews) {
        this(screen, width, height, 1.0, tabs, tabViews);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GUITabView(GUIScreen screen, double width, double height, double scale, GUIElement[] tabs, GUIView ... tabViews) {
        super(screen, width, height);
        this.scale = scale;
        if (tabs.length != tabViews.length) {
            if (tabViews.length != 0) throw new IllegalStateException("There must be the same number of tab names and tab elements!");
            this.tabViews = GUITabView.genTabViews(screen, tabs.length);
        } else {
            this.tabViews.addAll(Arrays.asList(tabViews));
        }
        this.tabs.addAll(Arrays.asList(tabs));
        for (GUIElement element : tabs) {
            this.children.add(element);
            element.parent = this;
            element.setExternalDeactivation(true, true);
        }
        for (GUIElement gUIElement : this.tabViews) {
            gUIElement.parent = this;
        }
        if (this.tabViews.size() > 0) {
            tabs[0].setActive(true);
            this.children.add(this.tabViews.get(0));
        }
        this.recalc(0);
    }

    public GUITabView(GUIScreen screen, double x, double y, double width, double height, String ... tabNames) {
        this(screen, x, y, width, height, 1.0, tabNames);
    }

    public GUITabView(GUIScreen screen, double x, double y, double width, double height, double scale, String ... tabNames) {
        this(screen, x, y, width, height, GUITabView.genTabs(screen, scale, tabNames), new GUIView[0]);
        this.autocalcTabs = true;
        this.autocalcTabviews = true;
        GUITextButton tab = (GUITextButton)this.tabs.get(0);
        this.tabBackground = new GUIGradientBorder(screen, 0.0, 0.0, 1.0, 1.0, 0.1, ((GUIGradientBorder)tab.background).border, ((GUIGradientBorder)tab.background).center);
        this.add(0, this.tabBackground);
        this.recalc(0);
    }

    public GUITabView(GUIScreen screen, double x, double y, double width, double height, String[] tabNames, GUIView ... tabViews) {
        this(screen, x, y, width, height, 1.0, tabNames, tabViews);
    }

    public GUITabView(GUIScreen screen, double x, double y, double width, double height, double scale, String[] tabNames, GUIView ... tabViews) {
        this(screen, x, y, width, height, GUITabView.genTabs(screen, scale, tabNames), tabViews);
        this.autocalcTabs = true;
        GUITextButton tab = (GUITextButton)this.tabs.get(0);
        this.tabBackground = new GUIGradientBorder(screen, 0.0, 0.0, 1.0, 1.0, 0.1, ((GUIGradientBorder)tab.background).border, ((GUIGradientBorder)tab.background).center);
        this.add(0, this.tabBackground);
        this.recalc(0);
    }

    public GUITabView(GUIScreen screen, double x, double y, double width, double height, GUIElement[] tabs, GUIView ... tabViews) {
        this(screen, x, y, width, height, 1.0, tabs, tabViews);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GUITabView(GUIScreen screen, double x, double y, double width, double height, double scale, GUIElement[] tabs, GUIView ... tabViews) {
        super(screen, x, y, width, height);
        this.scale = scale;
        if (tabs.length != tabViews.length) {
            if (tabViews.length != 0) throw new IllegalStateException("There must be the same number of tab names and tab elements!");
            this.tabViews = GUITabView.genTabViews(screen, tabs.length);
        } else {
            this.tabViews.addAll(Arrays.asList(tabViews));
        }
        this.tabs.addAll(Arrays.asList(tabs));
        for (GUIElement element : tabs) {
            this.children.add(element);
            element.parent = this;
            element.setExternalDeactivation(true, true);
        }
        for (GUIElement gUIElement : this.tabViews) {
            gUIElement.parent = this;
        }
        if (this.tabViews.size() > 0) {
            tabs[0].setActive(true);
            this.children.add(this.tabViews.get(0));
        }
        this.recalc(0);
    }

    private static GUIElement[] genTabs(GUIScreen screen, double scale, String[] tabNames) {
        GUIElement[] result = new GUIElement[tabNames.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new GUITextButton(screen, 0.0, 0.0, tabNames[i], Color.WHITE, T_GRAY, scale);
        }
        return result;
    }

    private static ArrayList<GUIView> genTabViews(GUIScreen screen, int count) {
        ArrayList<GUIView> result = new ArrayList<GUIView>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new GUIView(screen, 0.0, 0.0, 1.0, 1.0));
        }
        return result;
    }

    public int currentTab() {
        return this.current;
    }

    public int addTab(String name) {
        GUIView view = new GUIView(this.screen, 0.0, 0.0, 1.0, 1.0);
        this.tabViews.add(view);
        view.parent = this;
        GUITextButton tab = new GUITextButton(this.screen, 0.0, 0.0, name, Color.WHITE, T_GRAY, this.scale);
        this.tabs.add(tab);
        this.add(tab);
        this.recalc(0);
        return this.tabs.size() - 1;
    }

    public void removeTab(int index) {
        GUIElement tab = this.tabs.get(index);
        if (this.current == index) {
            this.setActiveTab(0);
        }
        this.tabs.remove(index);
        this.remove(tab);
        this.tabViews.remove(index);
    }

    @Override
    public GUITabView recalc(int subIndexChanged) {
        if (this.autocalcTabs) {
            double xx = 0.0;
            double yy = 0.0;
            for (GUIElement tab : this.tabs) {
                if (xx + tab.width > 1.0) {
                    yy += tab.height;
                    xx = 0.0;
                }
                tab.x = xx;
                tab.y = yy;
                xx += tab.width;
            }
            yy += this.tabs.get((int)0).height;
            if (this.autocalcTabviews) {
                for (GUIView view : this.tabViews) {
                    view.y = yy;
                    view.height = 1.0 - yy;
                }
            }
        }
        if (this.tabBackground != null) {
            GUIElement element = this.tabs.get(this.tabs.size() - 1);
            this.tabBackground.height = element.y + element.height;
        }
        this.recalcAndRepositionSubElements(0);
        this.postRecalc();
        return this;
    }

    public void setActiveTab(int index) {
        GUIElement currentElement = this.tabs.get(index);
        for (GUIElement element : this.tabs) {
            element.setActive(element == currentElement, true);
        }
        if (index == this.current) {
            return;
        }
        int i = this.children.indexOf(this.tabViews.get(this.current));
        this.children.remove(i);
        this.current = index;
        this.children.add(i, this.tabViews.get(this.current).recalc(0));
    }

    @Override
    public boolean mouseReleased(double x, double y, int button) {
        boolean result = false;
        if (button == 0) {
            if (this.active && this.isMouseWithin()) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new GUILeftClickEvent(this.screen, this))) {
                    this.click();
                }
                result = true;
            }
            this.setActive(false);
        }
        int index = -1;
        block0: for (GUIElement child : (ArrayList)this.children.clone()) {
            if (!child.mouseReleased(x - this.x, y - this.y, button)) continue;
            for (int i = 0; i < this.tabs.size(); ++i) {
                GUIElement tab = this.tabs.get(i);
                if (child != tab) continue;
                index = i;
                continue block0;
            }
        }
        if (index != -1 && index != this.current) {
            this.setActiveTab(index);
        } else {
            this.setActiveTab(this.current);
        }
        return result;
    }
}

