/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.view;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.view.GUIView;
import com.fantasticsource.tools.Tools;
import net.minecraft.client.renderer.GlStateManager;

public class GUIScrollView
extends GUIView {
    public double internalHeight;
    public double progress = -1.0;
    public double top;
    public double bottom;

    public GUIScrollView(GUIScreen screen, double width, double height, GUIElement ... subElements) {
        super(screen, width, height);
        for (GUIElement element : subElements) {
            this.children.add(element);
            element.parent = this;
        }
        this.recalc(0);
    }

    public GUIScrollView(GUIScreen screen, double x, double y, double width, double height, GUIElement ... subElements) {
        super(screen, x, y, width, height);
        for (GUIElement element : subElements) {
            this.children.add(element);
            element.parent = this;
        }
        this.recalc(0);
    }

    public GUIElement recalcThisOnly() {
        this.internalHeight = 0.0;
        for (GUIElement element : this.children) {
            this.internalHeight = Tools.max(this.internalHeight, element.y + element.height);
        }
        this.recalc2();
        return this;
    }

    @Override
    public GUIElement recalc(int subIndexChanged) {
        this.recalcAndRepositionSubElements(subIndexChanged);
        this.recalcThisOnly();
        this.postRecalc();
        return this;
    }

    protected void recalc2() {
        if (this.internalHeight <= 1.0) {
            this.progress = -1.0;
            this.top = 0.0;
        } else {
            if (this.progress == -1.0) {
                this.progress = 0.0;
            }
            this.top = (this.internalHeight - 1.0) * this.progress;
        }
        this.bottom = this.top + 1.0;
    }

    public void focus(GUIElement child) {
        if (!this.children.contains(child)) {
            return;
        }
        if (this.internalHeight <= this.height) {
            return;
        }
        this.progress = Tools.min(1.0, child.y * this.height / (this.internalHeight - this.height));
    }

    @Override
    public void draw() {
        this.recalc2();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)(-this.top), (double)0.0);
        this.drawChildren();
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean mousePressed(double x, double y, int button) {
        this.recalc2();
        return super.mousePressed(x, y, button);
    }

    @Override
    public boolean mouseReleased(double x, double y, int button) {
        this.recalc2();
        return super.mouseReleased(x, y, button);
    }

    @Override
    public void mouseDrag(double x, double y, int button) {
        this.recalc2();
        super.mouseDrag(x, y, button);
    }

    @Override
    public void mouseWheel(double x, double y, int delta) {
        this.recalc2();
        super.mouseWheel(x, y, delta);
    }
}

