/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.view;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.other.GUIButton;
import com.fantasticsource.mctools.gui.element.other.GUIGradient;
import com.fantasticsource.mctools.gui.element.view.GUIAutocroppedView;
import com.fantasticsource.mctools.gui.element.view.GUIScrollView;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;

public abstract class GUIList
extends GUIScrollView {
    public static final Color AL_WHITE = Color.WHITE.copy().setAF(0.3f);
    public static final Color AL_BLACK = Color.BLACK.copy().setAF(0.3f);
    public final boolean editable;

    public GUIList(GUIScreen screen, boolean editable, double width, double height, GUIElement ... subElements) {
        super(screen, width, height, subElements);
        this.editable = editable;
        if (editable) {
            this.addAddLineLine();
        }
    }

    public GUIList(GUIScreen screen, boolean editable, double x, double y, double width, double height, GUIElement ... subElements) {
        super(screen, x, y, width, height, subElements);
        this.editable = editable;
        if (editable) {
            this.addAddLineLine();
        }
    }

    private void addAddLineLine() {
        Line line = new Line(this.screen, this.editable);
        line.add(new GUIElement(this.screen, 1.0, 0.0));
        line.add(GUIButton.newAddButton(this.screen)).addClickActions(this::addLine);
        this.add(line);
    }

    public Line addLine() {
        return this.addLine(this.newLineDefaultElements());
    }

    public Line addLine(int index) {
        return this.addLine(index, this.newLineDefaultElements());
    }

    public Line addLine(GUIElement ... lineElements) {
        return this.addLine(this.lineCount(), lineElements);
    }

    public Line addLine(int index, GUIElement ... lineElements) {
        if (index > this.lineCount()) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + this.lineCount());
        }
        Line line = new Line(this.screen, this.editable, this.newLineBackgroundElement());
        line.add(new GUIElement(this.screen, 1.0, 0.0));
        if (this.editable) {
            GUIButton button = GUIButton.newAddButton(this.screen);
            line.add(button).addClickActions(() -> {
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).indexOf(button) == -1) continue;
                    this.addLine(i);
                    break;
                }
            });
            line.add(GUIButton.newRemoveButton(this.screen).addClickActions(() -> this.remove(line)));
        }
        if (lineElements != null) {
            line.addAll(lineElements);
        }
        this.add(index, line);
        return line;
    }

    public GUIList addAllLines(GUIElement[] ... lines) {
        for (GUIElement[] line : lines) {
            this.addLine(line);
        }
        return this;
    }

    public Line[] getLines() {
        Line[] result = new Line[this.lineCount()];
        System.arraycopy(this.children.toArray(new Line[0]), 0, result, 0, result.length);
        return result;
    }

    public Line getLine(int index) {
        return this.get(index);
    }

    public Line getLastFilledLine() {
        return this.getLine(this.lineCount() - 1);
    }

    public final double buttonWidth() {
        GUIElement button = ((GUIElement)this.children.get(this.children.size() - 1)).get(1);
        return button.width;
    }

    public abstract GUIElement[] newLineDefaultElements();

    public GUIElement newLineBackgroundElement() {
        return new GUIGradient(this.screen, 1.0, 1.0, AL_BLACK, AL_BLACK, AL_WHITE, AL_WHITE);
    }

    public int lineCount() {
        return this.editable ? this.size() - 1 : this.size();
    }

    @Override
    public Line get(int index) {
        return (Line)super.get(index);
    }

    public static class Line
    extends GUIAutocroppedView {
        public final boolean editable;

        public Line(GUIScreen screen, boolean editable) {
            this(screen, editable, 0.0);
        }

        public Line(GUIScreen screen, boolean editable, double padding) {
            this(screen, editable, padding, null);
        }

        public Line(GUIScreen screen, boolean editable, GUIElement background) {
            this(screen, editable, 0.0, background);
        }

        public Line(GUIScreen screen, boolean editable, double padding, GUIElement background) {
            super(screen, padding, background);
            this.editable = editable;
        }

        public Line(GUIScreen screen, boolean editable, double x, double y) {
            this(screen, editable, x, y, 0.0);
        }

        public Line(GUIScreen screen, boolean editable, double x, double y, double padding) {
            this(screen, editable, x, y, padding, null);
        }

        public Line(GUIScreen screen, boolean editable, double x, double y, GUIElement background) {
            this(screen, editable, x, y, 0.0, background);
        }

        public Line(GUIScreen screen, boolean editable, double x, double y, double padding, GUIElement background) {
            super(screen, x, y, padding, background);
            this.editable = editable;
        }

        public ArrayList<GUIElement> getLineElements() {
            int offset;
            int n = offset = this.editable ? 3 : 1;
            if (this.size() > 0 && this.get(0) == this.background) {
                ++offset;
            }
            if (this.size() <= offset) {
                return new ArrayList<GUIElement>();
            }
            ArrayList<GUIElement> list = new ArrayList<GUIElement>();
            for (int i = offset; i < this.children.size(); ++i) {
                list.add(this.get(i));
            }
            return list;
        }

        public GUIElement getLineElement(int index) {
            return this.getLineElements().get(index);
        }
    }
}

