/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text.filter;

import com.fantasticsource.mctools.gui.element.text.filter.TextFilter;
import java.util.LinkedHashMap;

public class FilterRangedInt
extends TextFilter<Integer> {
    private static LinkedHashMap<String, FilterRangedInt> instances = new LinkedHashMap();
    private final int min;
    private final int max;

    private FilterRangedInt(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public static FilterRangedInt get(int min, int max) {
        return instances.computeIfAbsent(min + "," + max, o -> new FilterRangedInt(min, max));
    }

    @Override
    public String transformInput(String input) {
        return input.trim();
    }

    @Override
    public boolean acceptable(String input) {
        String transformed = this.transformInput(input);
        if (transformed.equals("")) {
            return false;
        }
        boolean first = true;
        boolean digits = false;
        for (char c : transformed.toCharArray()) {
            if (c == '-' && first) {
                first = false;
                continue;
            }
            first = false;
            if (c < '0' || c > '9') {
                return false;
            }
            digits = true;
        }
        if (!digits) {
            return false;
        }
        int i = Integer.parseInt(transformed);
        return i >= this.min && i <= this.max;
    }

    @Override
    public Integer parse(String input) {
        return !this.acceptable(input) ? null : Integer.valueOf(Integer.parseInt(input));
    }
}

