/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text.filter;

import com.fantasticsource.mctools.gui.element.text.filter.TextFilter;

public class FilterFloat
extends TextFilter<Float> {
    public static final FilterFloat INSTANCE = new FilterFloat();

    private FilterFloat() {
    }

    @Override
    public String transformInput(String input) {
        return input.trim();
    }

    @Override
    public boolean acceptable(String input) {
        if ((input = this.transformInput(input)).equals("")) {
            return false;
        }
        if (input.indexOf(46) != input.lastIndexOf(46)) {
            return false;
        }
        boolean first = true;
        for (char c : input.toCharArray()) {
            if (!(c >= '0' && c <= '9' || c == '.' || first && c == '-')) {
                return false;
            }
            first = false;
        }
        int ignored = 0;
        if (input.contains("-")) {
            ++ignored;
        }
        if (input.contains(".")) {
            ++ignored;
        }
        return input.length() > ignored;
    }

    @Override
    public Float parse(String input) {
        return !this.acceptable(input) ? null : Float.valueOf(Float.parseFloat(input));
    }
}

