/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.text.GUIText;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;

public class GUITextSpoiler
extends GUIText {
    private boolean hidden = true;
    private ArrayList<GUIElement> hideableElements = new ArrayList();

    public GUITextSpoiler(GUIScreen screen, String text, GUIElement ... hideableElements) {
        this(screen, text, Color.WHITE, 1.0, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, String text, double scale, GUIElement ... hideableElements) {
        this(screen, text, Color.WHITE, scale, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, String text, Color color, GUIElement ... hideableElements) {
        this(screen, text, color, color, color, 1.0, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, String text, Color color, double scale, GUIElement ... hideableElements) {
        this(screen, text, color, color, color, scale, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, String text, Color color, Color hoverColor, Color activeColor, GUIElement ... hideableElements) {
        this(screen, text, color, hoverColor, activeColor, 1.0, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, String text, Color color, Color hoverColor, Color activeColor, double scale, GUIElement ... hideableElements) {
        super(screen, text.charAt(text.length() - 1) == '\n' ? text : text + '\n', color, hoverColor, activeColor, scale);
        for (GUIElement element : hideableElements) {
            this.add(element);
        }
    }

    public GUITextSpoiler(GUIScreen screen, double x, double y, String text, GUIElement ... hideableElements) {
        this(screen, x, y, text, Color.WHITE, 1.0, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, double x, double y, String text, double scale, GUIElement ... hideableElements) {
        this(screen, x, y, text, Color.WHITE, scale, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, double x, double y, String text, Color color, GUIElement ... hideableElements) {
        this(screen, x, y, text, color, color, color, 1.0, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, double x, double y, String text, Color color, double scale, GUIElement ... hideableElements) {
        this(screen, x, y, text, color, color, color, scale, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, double x, double y, String text, Color color, Color hoverColor, Color activeColor, GUIElement ... hideableElements) {
        this(screen, x, y, text, color, hoverColor, activeColor, 1.0, hideableElements);
    }

    public GUITextSpoiler(GUIScreen screen, double x, double y, String text, Color color, Color hoverColor, Color activeColor, double scale, GUIElement ... hideableElements) {
        super(screen, x, y, text.charAt(text.length() - 1) == '\n' ? text : text + '\n', color, hoverColor, activeColor, scale);
        for (GUIElement element : hideableElements) {
            this.add(element);
        }
    }

    @Override
    public GUITextSpoiler add(GUIElement hideableElement) {
        boolean reshow;
        if (this.hideableElements == null) {
            return null;
        }
        boolean bl = reshow = !this.hidden;
        if (reshow) {
            this.hide();
        }
        this.hideableElements.add(hideableElement);
        if (reshow) {
            this.show();
        }
        return this;
    }

    @Override
    public GUIElement add(int index, GUIElement hideableElement) {
        boolean reshow;
        if (this.hideableElements == null) {
            return null;
        }
        boolean bl = reshow = !this.hidden;
        if (reshow) {
            this.hide();
        }
        this.hideableElements.add(index, hideableElement);
        if (reshow) {
            this.show();
        }
        return this;
    }

    @Override
    public void remove(GUIElement element) {
        if (this.hideableElements == null) {
            return;
        }
        this.hideableElements.remove(element);
    }

    @Override
    public void remove(int index) {
        if (this.hideableElements == null) {
            return;
        }
        this.hideableElements.remove(index);
    }

    @Override
    public int indexOf(GUIElement hideableElement) {
        if (this.hideableElements == null) {
            return -1;
        }
        return this.hideableElements.indexOf(hideableElement);
    }

    @Override
    public void clear() {
        if (this.hideableElements == null) {
            return;
        }
        this.hideableElements.clear();
    }

    @Override
    public int size() {
        if (this.hideableElements == null) {
            return 0;
        }
        return this.hideableElements.size();
    }

    @Override
    public GUIElement get(int index) {
        if (this.hideableElements == null) {
            return null;
        }
        return this.hideableElements.get(index);
    }

    public void show() {
        if (!this.hidden) {
            return;
        }
        this.hidden = false;
        int index = this.parent.indexOf(this);
        for (GUIElement element : this.hideableElements) {
            this.parent.add(++index, element);
        }
    }

    public void hide() {
        if (this.hidden) {
            return;
        }
        this.hidden = true;
        for (GUIElement element : this.hideableElements) {
            this.parent.remove(element);
        }
    }

    public void toggle() {
        if (this.hidden) {
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void click() {
        this.toggle();
        super.click();
    }
}

