/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text;

import com.fantasticsource.mctools.MonoASCIIFontRenderer;
import com.fantasticsource.mctools.Render;
import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.text.CodeInput;
import com.fantasticsource.mctools.gui.element.text.GUIMultilineTextInput;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;

public class GUIText
extends GUIElement {
    public final double scale;
    public String oldText;
    protected String text;
    protected ArrayList<String> lines = new ArrayList();
    protected ArrayList<String> fullLines = new ArrayList();
    protected Color color;
    protected Color hoverColor;
    protected Color activeColor;

    public GUIText(GUIScreen screen, String text) {
        this(screen, text, Color.WHITE, 1.0);
    }

    public GUIText(GUIScreen screen, String text, double scale) {
        this(screen, text, Color.WHITE, scale);
    }

    public GUIText(GUIScreen screen, String text, Color color) {
        this(screen, text, color, color, color, 1.0);
    }

    public GUIText(GUIScreen screen, String text, Color color, double scale) {
        this(screen, text, color, color, color, scale);
    }

    public GUIText(GUIScreen screen, String text, Color color, Color hoverColor, Color activeColor) {
        this(screen, text, color, hoverColor, activeColor, 1.0);
    }

    public GUIText(GUIScreen screen, String text, Color color, Color hoverColor, Color activeColor, double scale) {
        super(screen, 0.0, 0.0);
        this.scale = scale * screen.textScale;
        this.text = text;
        this.oldText = text;
        this.color = color;
        this.hoverColor = hoverColor;
        this.activeColor = activeColor;
        this.recalc(0);
    }

    public GUIText(GUIScreen screen, double x, double y, String text) {
        this(screen, x, y, text, Color.WHITE, 1.0);
    }

    public GUIText(GUIScreen screen, double x, double y, String text, double scale) {
        this(screen, x, y, text, Color.WHITE, scale);
    }

    public GUIText(GUIScreen screen, double x, double y, String text, Color color) {
        this(screen, x, y, text, color, color, color, 1.0);
    }

    public GUIText(GUIScreen screen, double x, double y, String text, Color color, double scale) {
        this(screen, x, y, text, color, color, color, scale);
    }

    public GUIText(GUIScreen screen, double x, double y, String text, Color color, Color hoverColor, Color activeColor) {
        this(screen, x, y, text, color, hoverColor, activeColor, 1.0);
    }

    public GUIText(GUIScreen screen, double x, double y, String text, Color color, Color hoverColor, Color activeColor, double scale) {
        super(screen, x, y, 0.0, 0.0);
        this.scale = scale * screen.textScale;
        this.text = text;
        this.oldText = text;
        this.color = color;
        this.hoverColor = hoverColor;
        this.activeColor = activeColor;
        this.recalc(0);
    }

    public GUIText setColor(Color color) {
        return this.setColor(color, color, color);
    }

    public GUIText setColor(Color color, Color hoverColor, Color activeColor) {
        this.color = color;
        this.hoverColor = hoverColor;
        this.activeColor = activeColor;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public GUIText setText(String text) {
        if (text.equals(this.text)) {
            return this;
        }
        this.oldText = this.text;
        this.text = text;
        this.screen.root.recalc(0);
        return this;
    }

    @Override
    public GUIText recalc(int subIndexChanged) {
        this.text = this.text.replaceAll("\r", "");
        this.lines.clear();
        this.fullLines.clear();
        if (this.parent instanceof CodeInput) {
            this.lines.add(this.text);
            this.fullLines.add(this.text);
            this.width = (double)MonoASCIIFontRenderer.getStringWidth(this.text) * this.scale / (double)this.screen.field_146294_l;
            this.height = (double)(MonoASCIIFontRenderer.LINE_HEIGHT + 2) * this.scale / (double)this.screen.field_146295_m;
        } else {
            StringBuilder previous = new StringBuilder();
            String[] words = Tools.preservedSplit(this.text, "[\n]|[ ]+", true);
            double parentW = this.parent == null ? 1.0 : this.parent.absoluteWidth();
            StringBuilder line = new StringBuilder();
            StringBuilder fullLine = new StringBuilder();
            int index = 0;
            double maxLineW = 0.0;
            double lineW = 0.0;
            while (index < words.length) {
                String word;
                if ((word = words[index++]).equals("")) continue;
                if (word.equals("\n")) {
                    this.lines.add(line.toString());
                    this.fullLines.add(fullLine.toString());
                    line = new StringBuilder();
                    fullLine = new StringBuilder("\n");
                    maxLineW = 1.0;
                    lineW = 0.0;
                } else {
                    double wordW = (double)Render.getPartialStringWidth(previous.toString().replaceAll("\n", ""), word.replaceAll("\n", "")) * this.scale / (double)this.screen.field_146294_l;
                    if (lineW + wordW > parentW) {
                        if (word.trim().equals("")) {
                            fullLine.append(word);
                            continue;
                        }
                        if (line.length() == 0) {
                            line.append(word);
                            fullLine.append(word);
                            lineW += wordW;
                        } else {
                            this.lines.add(line.toString());
                            this.fullLines.add(fullLine.toString());
                            line = new StringBuilder(word);
                            fullLine = new StringBuilder(word);
                            maxLineW = parentW;
                            lineW = (double)Render.getPartialStringWidth(previous.toString().replaceAll("\n", ""), word.replaceAll("\n", "")) * this.scale / (double)this.screen.field_146294_l;
                        }
                    } else {
                        line.append(word);
                        fullLine.append(word);
                        lineW += wordW;
                    }
                }
                previous.append(word);
            }
            if (line.length() > 0) {
                this.lines.add(line.toString());
                maxLineW = Tools.max(maxLineW, lineW);
            }
            if (fullLine.length() > 0) {
                this.fullLines.add(fullLine.toString());
            }
            this.width = maxLineW;
            this.height = this instanceof GUIMultilineTextInput && this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == '\n' ? (double)(Tools.max(1, this.fullLines.size()) * GUIScreen.FONT_RENDERER.field_78288_b - 1) * this.scale / (double)this.screen.field_146295_m : (double)(Tools.max(1, this.lines.size()) * GUIScreen.FONT_RENDERER.field_78288_b - 1) * this.scale / (double)this.screen.field_146295_m;
        }
        if (this.parent != null) {
            this.width /= this.parent.absoluteWidth();
            this.height /= this.parent.absoluteHeight();
        }
        this.width += 1.0 * this.width / (double)this.screen.field_146294_l;
        this.recalcAndRepositionSubElements(0);
        this.postRecalc();
        return this;
    }

    @Override
    public void draw() {
        GlStateManager.func_179098_w();
        GlStateManager.func_179094_E();
        double adjustedScale = this.scale * (double)new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
        GlStateManager.func_179139_a((double)(adjustedScale / (double)this.absolutePxWidth()), (double)(adjustedScale / (double)this.absolutePxHeight()), (double)1.0);
        Color c = this.active ? this.activeColor : (this.isMouseWithin() ? this.hoverColor : this.color);
        int yy = 0;
        for (String line : this.lines) {
            GUIScreen.FONT_RENDERER.func_175065_a(line, 0.0f, (float)yy, c.color() >> 8 | c.a() << 24, false);
            yy += GUIScreen.FONT_RENDERER.field_78288_b;
        }
        GlStateManager.func_179121_F();
        this.drawChildren();
    }

    @Override
    public String toString() {
        return this.text;
    }
}

