/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.text.GUITextInput;
import com.fantasticsource.mctools.gui.element.text.filter.FilterNone;
import com.fantasticsource.mctools.gui.element.view.GUIScrollView;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;

public class CodeInput
extends GUIScrollView {
    public final double scale;
    public Color color;
    public Color hoverColor;
    public Color activeColor;
    public Color highlightColor;
    protected int cursorX;
    protected int selectionStartY = -1;

    public CodeInput(GUIScreen screen, double width, double height, String ... lines) {
        this(screen, width, height, 1.0, lines);
    }

    public CodeInput(GUIScreen screen, double width, double height, double scale, String ... lines) {
        this(screen, width, height, GUIScreen.getIdleColor(Color.WHITE), GUIScreen.getHoverColor(Color.WHITE), Color.WHITE, Color.WHITE.copy().setAF(0.4f), scale, lines);
    }

    public CodeInput(GUIScreen screen, double width, double height, Color color, Color hoverColor, Color activeColor, Color hightlightColor, String ... lines) {
        this(screen, width, height, color, hoverColor, activeColor, hightlightColor, 1.0, lines);
    }

    public CodeInput(GUIScreen screen, double width, double height, Color color, Color hoverColor, Color activeColor, Color hightlightColor, double scale, String ... lines) {
        super(screen, width, height, new GUIElement[0]);
        this.scale = scale;
        this.color = color;
        this.hoverColor = hoverColor;
        this.activeColor = activeColor;
        this.highlightColor = hightlightColor;
        if (lines.length == 0) {
            this.add("");
        } else {
            for (String line : lines) {
                this.add(line);
            }
        }
        this.cursorX = ((GUITextInput)this.children.get((int)0)).text.length();
    }

    public CodeInput(GUIScreen screen, double x, double y, double width, double height, String ... lines) {
        this(screen, x, y, width, height, 1.0, lines);
    }

    public CodeInput(GUIScreen screen, double x, double y, double width, double height, double scale, String ... lines) {
        this(screen, x, y, width, height, GUIScreen.getIdleColor(Color.WHITE), GUIScreen.getHoverColor(Color.WHITE), Color.WHITE, Color.WHITE.copy().setAF(0.4f), scale, lines);
    }

    public CodeInput(GUIScreen screen, double x, double y, double width, double height, Color color, Color hoverColor, Color activeColor, Color hightlightColor, String ... lines) {
        this(screen, x, y, width, height, color, hoverColor, activeColor, hightlightColor, 1.0, lines);
    }

    public CodeInput(GUIScreen screen, double x, double y, double width, double height, Color color, Color hoverColor, Color activeColor, Color hightlightColor, double scale, String ... lines) {
        super(screen, x, y, width, height, new GUIElement[0]);
        this.scale = scale;
        this.color = color;
        this.hoverColor = hoverColor;
        this.activeColor = activeColor;
        this.highlightColor = hightlightColor;
        if (lines.length == 0) {
            this.add("");
        } else {
            for (String line : lines) {
                this.add(line);
            }
        }
        this.cursorX = ((GUITextInput)this.children.get((int)0)).text.length();
    }

    @Override
    public GUIElement recalc(int subIndexChanged) {
        this.internalHeight = 0.0;
        GUIElement prev = null;
        for (GUIElement element : this.children) {
            element.recalc(0);
            element.y = prev == null ? 0.0 : prev.y + prev.height;
            prev = element;
            this.internalHeight = Tools.max(this.internalHeight, element.y + element.height);
        }
        this.recalc2();
        this.postRecalc();
        return this;
    }

    @Override
    public GUIElement add(GUIElement element) {
        if (!(element instanceof GUITextInput)) {
            throw new IllegalArgumentException("Multiline text inputs can only have text inputs added to them!");
        }
        return this.add(((GUITextInput)element).text);
    }

    @Override
    public GUIElement add(int index, GUIElement element) {
        if (!(element instanceof GUITextInput)) {
            throw new IllegalArgumentException("Multiline text inputs can only have text inputs added to them!");
        }
        return this.add(index, ((GUITextInput)element).text);
    }

    public GUIElement add(String s) {
        if (this.children.size() == 0) {
            return super.add(new GUITextInput(this.screen, 0.0, 0.0, s, FilterNone.INSTANCE, this.activeColor, this.scale));
        }
        GUIElement element = (GUIElement)this.children.get(this.children.size() - 1);
        return super.add(new GUITextInput(this.screen, 0.0, element.y + (element.height + 1.0 / (double)this.screen.field_146295_m) / this.height, s, FilterNone.INSTANCE, this.activeColor, this.scale));
    }

    public GUIElement add(int index, String s) {
        if (index == 0) {
            return this.add(s);
        }
        GUIElement element = (GUIElement)this.children.get(index - 1);
        GUITextInput newElement = new GUITextInput(this.screen, 0.0, element.y + (element.height + 1.0 / (double)this.screen.field_146295_m) / this.height, s, FilterNone.INSTANCE, this.activeColor, this.scale);
        for (int i = index; i < this.children.size(); ++i) {
            element = (GUIElement)this.children.get(i);
            element.y += (1.0 / (double)this.screen.field_146295_m + newElement.height) / this.height;
        }
        return super.add(index, newElement);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        for (GUIElement element : this.children) {
            if (!element.isActive()) continue;
            element.keyTyped(typedChar, keyCode);
            break;
        }
    }
}

